/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bitvectors;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.bitvectors.FlatBitVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.TaskExecutor;

public final class HnswBitVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "HnswBitVectorsFormat";
    private final int maxConn;
    private final int beamWidth;
    private final FlatVectorsFormat flatVectorsFormat;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;

    public HnswBitVectorsFormat() {
        this(16, 100, 1, null);
    }

    public HnswBitVectorsFormat(int maxConn, int beamWidth) {
        this(maxConn, beamWidth, 1, null);
    }

    public HnswBitVectorsFormat(int maxConn, int beamWidth, int numMergeWorkers, ExecutorService mergeExec) {
        super(NAME);
        if (maxConn <= 0 || maxConn > 512) {
            throw new IllegalArgumentException("maxConn must be positive and less than or equal to 512; maxConn=" + maxConn);
        }
        if (beamWidth <= 0 || beamWidth > 3200) {
            throw new IllegalArgumentException("beamWidth must be positive and less than or equal to 3200; beamWidth=" + beamWidth);
        }
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        if (numMergeWorkers == 1 && mergeExec != null) {
            throw new IllegalArgumentException("No executor service is needed as we'll use single thread to merge");
        }
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec != null ? new TaskExecutor((Executor)mergeExec) : null;
        this.flatVectorsFormat = new Lucene99FlatVectorsFormat((FlatVectorsScorer)new FlatBitVectorsScorer());
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new FlatBitVectorsWriter((KnnVectorsWriter)new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, this.flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, this.flatVectorsFormat.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "HnswBitVectorsFormat(name=HnswBitVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", flatVectorFormat=" + String.valueOf(this.flatVectorsFormat) + ")";
    }

    private static class FlatBitVectorsWriter
    extends KnnVectorsWriter {
        private final KnnVectorsWriter delegate;

        public FlatBitVectorsWriter(KnnVectorsWriter delegate) {
            this.delegate = delegate;
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.delegate.mergeOneField(fieldInfo, mergeState);
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            if (fieldInfo.getVectorEncoding() != VectorEncoding.BYTE) {
                throw new IllegalArgumentException("HnswBitVectorsFormat only supports BYTE encoding");
            }
            return this.delegate.addField(fieldInfo);
        }

        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.delegate.flush(maxDoc, sortMap);
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }
}

