/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Comparator;

public class ScoreDoc {
    public float score;
    public int doc;
    public int shardIndex;
    public static final Comparator<ScoreDoc> COMPARATOR = (a, b) -> {
        if (a.score > b.score) {
            return -1;
        }
        if (a.score < b.score) {
            return 1;
        }
        return a.doc - b.doc;
    };

    public ScoreDoc(int doc, float score) {
        this(doc, score, -1);
    }

    public ScoreDoc(int doc, float score, int shardIndex) {
        this.doc = doc;
        this.score = score;
        this.shardIndex = shardIndex;
    }

    public String toString() {
        return "doc=" + this.doc + " score=" + this.score + " shardIndex=" + this.shardIndex;
    }
}

