/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.ArrayUtil;

public abstract class DoubleValuesSourceRescorer
extends Rescorer {
    private final DoubleValuesSource valuesSource;

    public DoubleValuesSourceRescorer(DoubleValuesSource valuesSource) {
        this.valuesSource = valuesSource;
    }

    protected abstract float combine(float var1, boolean var2, double var3);

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        DoubleValuesSource source = this.valuesSource.rewrite(searcher);
        ScoreDoc[] hits = (ScoreDoc[])firstPassTopDocs.scoreDocs.clone();
        Arrays.sort(hits, (a, b) -> a.doc - b.doc);
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        LeafReaderContext ctx = leaves.getFirst();
        int currLeaf = 0;
        int leafEnd = ctx.docBase + ctx.reader().maxDoc();
        for (ScoreDoc hit : hits) {
            while (hit.doc >= leafEnd) {
                if (currLeaf == leaves.size() - 1) {
                    throw new IllegalStateException("hit docId=" + hit.doc + "greater than last searcher leaf maxDoc=" + leafEnd + " Ensure firstPassTopDocs were produced by the searcher provided to rescore.");
                }
                ctx = leaves.get(++currLeaf);
                leafEnd = ctx.docBase + ctx.reader().maxDoc();
            }
            int targetDoc = hit.doc - ctx.docBase;
            DoubleValues values = source.getValues(ctx, null);
            boolean scorePresent = values.advanceExact(targetDoc);
            double secondPassScore = scorePresent ? values.doubleValue() : 0.0;
            hit.score = this.combine(hit.score, scorePresent, secondPassScore);
        }
        if (topN < hits.length) {
            ArrayUtil.select(hits, 0, hits.length, topN, ScoreDoc.COMPARATOR);
            ScoreDoc[] subset = new ScoreDoc[topN];
            System.arraycopy(hits, 0, subset, 0, topN);
            hits = subset;
        }
        Arrays.sort(hits, ScoreDoc.COMPARATOR);
        return new TopDocs(firstPassTopDocs.totalHits, hits);
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        Explanation first = Explanation.match(firstPassExplanation.getValue(), "first pass score", firstPassExplanation);
        LeafReaderContext leafWithDoc = null;
        for (LeafReaderContext ctx : searcher.getIndexReader().leaves()) {
            if (docID < ctx.docBase || docID >= ctx.docBase + ctx.reader().maxDoc()) continue;
            leafWithDoc = ctx;
            break;
        }
        if (leafWithDoc == null) {
            throw new IllegalArgumentException("docId=" + docID + " not found in any leaf in provided searcher");
        }
        DoubleValuesSource source = this.valuesSource.rewrite(searcher);
        Explanation doubleValuesMatch = source.explain(leafWithDoc, docID - leafWithDoc.docBase, Explanation.noMatch("DoubleValuesSource was not initialized with query scores", new Explanation[0]));
        Explanation second = doubleValuesMatch.isMatch() ? Explanation.match(doubleValuesMatch.getValue(), "value from DoubleValuesSource", doubleValuesMatch) : Explanation.noMatch("no value in DoubleValuesSource", new Explanation[0]);
        float score = this.combine(first.getValue().floatValue(), doubleValuesMatch.isMatch(), doubleValuesMatch.getValue().doubleValue());
        String desc = "combined score from firstPass and DoubleValuesSource=" + String.valueOf(source.getClass()) + " using " + String.valueOf(this.getClass());
        return Explanation.match((Number)Float.valueOf(score), desc, first, second);
    }
}

