/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;

public abstract class DocIdSetIterator {
    public static final int NO_MORE_DOCS = Integer.MAX_VALUE;

    public static DocIdSetIterator empty() {
        return new RangeDocIdSetIterator(0, 0);
    }

    public static DocIdSetIterator all(int maxDoc) {
        if (maxDoc < 0) {
            throw new IllegalArgumentException("maxDoc must be >= 0, but got maxDoc=" + maxDoc);
        }
        return new RangeDocIdSetIterator(0, maxDoc);
    }

    public static DocIdSetIterator range(int minDoc, int maxDoc) {
        if (minDoc >= maxDoc) {
            throw new IllegalArgumentException("minDoc must be < maxDoc but got minDoc=" + minDoc + " maxDoc=" + maxDoc);
        }
        if (minDoc < 0) {
            throw new IllegalArgumentException("minDoc must be >= 0 but got minDoc=" + minDoc);
        }
        return new RangeDocIdSetIterator(minDoc, maxDoc);
    }

    public abstract int docID();

    public abstract int nextDoc() throws IOException;

    public abstract int advance(int var1) throws IOException;

    protected final int slowAdvance(int target) throws IOException {
        int doc;
        assert (this.docID() < target);
        while ((doc = this.nextDoc()) < target) {
        }
        return doc;
    }

    public abstract long cost();

    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        assert (offset <= this.docID()) : "offset=" + offset + " docID()=" + this.docID() + " upTo=" + upTo;
        int doc = this.docID();
        while (doc < upTo) {
            bitSet.set(doc - offset);
            doc = this.nextDoc();
        }
    }

    public int docIDRunEnd() throws IOException {
        return this.docID() + 1;
    }

    private static class RangeDocIdSetIterator
    extends AbstractDocIdSetIterator {
        private final int minDoc;
        private final int maxDoc;

        RangeDocIdSetIterator(int minDoc, int maxDoc) {
            assert (minDoc <= maxDoc);
            this.minDoc = minDoc;
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) {
            this.doc = target >= this.maxDoc ? Integer.MAX_VALUE : (target < this.minDoc ? this.minDoc : target);
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc - this.minDoc;
        }

        @Override
        public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
            assert (offset <= this.doc);
            if ((upTo = Math.min(upTo, this.maxDoc)) > this.doc) {
                bitSet.set(this.doc - offset, upTo - offset);
                this.advance(upTo);
            }
        }

        @Override
        public int docIDRunEnd() throws IOException {
            return this.maxDoc;
        }
    }
}

