/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiSorter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.packed.PackedLongValues;

public class MergeState {
    public final DocMap[] docMaps;
    public final SegmentInfo segmentInfo;
    public FieldInfos mergeFieldInfos;
    public final StoredFieldsReader[] storedFieldsReaders;
    public final TermVectorsReader[] termVectorsReaders;
    public final NormsProducer[] normsProducers;
    public final DocValuesProducer[] docValuesProducers;
    public final FieldInfos[] fieldInfos;
    public final Bits[] liveDocs;
    public final FieldsProducer[] fieldsProducers;
    public final PointsReader[] pointsReaders;
    public final KnnVectorsReader[] knnVectorsReaders;
    public final int[] maxDocs;
    public final InfoStream infoStream;
    public final Executor intraMergeTaskExecutor;
    public boolean needsIndexSort;

    MergeState(List<CodecReader> readers, SegmentInfo segmentInfo, InfoStream infoStream, Executor intraMergeTaskExecutor) throws IOException {
        MergeState.verifyIndexSort(readers, segmentInfo);
        this.infoStream = infoStream;
        int numReaders = readers.size();
        this.intraMergeTaskExecutor = intraMergeTaskExecutor;
        this.maxDocs = new int[numReaders];
        this.fieldsProducers = new FieldsProducer[numReaders];
        this.normsProducers = new NormsProducer[numReaders];
        this.storedFieldsReaders = new StoredFieldsReader[numReaders];
        this.termVectorsReaders = new TermVectorsReader[numReaders];
        this.docValuesProducers = new DocValuesProducer[numReaders];
        this.pointsReaders = new PointsReader[numReaders];
        this.knnVectorsReaders = new KnnVectorsReader[numReaders];
        this.fieldInfos = new FieldInfos[numReaders];
        this.liveDocs = new Bits[numReaders];
        int numDocs = 0;
        for (int i = 0; i < numReaders; ++i) {
            CodecReader reader = readers.get(i);
            this.maxDocs[i] = reader.maxDoc();
            this.liveDocs[i] = reader.getLiveDocs();
            this.fieldInfos[i] = reader.getFieldInfos();
            this.normsProducers[i] = reader.getNormsReader();
            if (this.normsProducers[i] != null) {
                this.normsProducers[i] = this.normsProducers[i].getMergeInstance();
            }
            this.docValuesProducers[i] = reader.getDocValuesReader();
            if (this.docValuesProducers[i] != null) {
                this.docValuesProducers[i] = this.docValuesProducers[i].getMergeInstance();
            }
            this.storedFieldsReaders[i] = reader.getFieldsReader();
            if (this.storedFieldsReaders[i] != null) {
                this.storedFieldsReaders[i] = this.storedFieldsReaders[i].getMergeInstance();
            }
            this.termVectorsReaders[i] = reader.getTermVectorsReader();
            if (this.termVectorsReaders[i] != null) {
                this.termVectorsReaders[i] = this.termVectorsReaders[i].getMergeInstance();
            }
            this.fieldsProducers[i] = reader.getPostingsReader();
            if (this.fieldsProducers[i] != null) {
                this.fieldsProducers[i] = this.fieldsProducers[i].getMergeInstance();
            }
            this.pointsReaders[i] = reader.getPointsReader();
            if (this.pointsReaders[i] != null) {
                this.pointsReaders[i] = this.pointsReaders[i].getMergeInstance();
            }
            this.knnVectorsReaders[i] = reader.getVectorReader();
            if (this.knnVectorsReaders[i] != null) {
                this.knnVectorsReaders[i] = this.knnVectorsReaders[i].getMergeInstance();
            }
            numDocs += reader.numDocs();
        }
        segmentInfo.setMaxDoc(numDocs);
        this.segmentInfo = segmentInfo;
        this.docMaps = this.buildDocMaps(readers, segmentInfo.getIndexSort());
    }

    private DocMap[] buildDeletionDocMaps(List<CodecReader> readers) {
        int totalDocs = 0;
        int numReaders = readers.size();
        DocMap[] docMaps = new DocMap[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            LeafReader reader = readers.get(i);
            Bits liveDocs = reader.getLiveDocs();
            PackedLongValues delDocMap = liveDocs != null ? MergeState.removeDeletes(reader.maxDoc(), liveDocs) : null;
            int docBase = totalDocs;
            docMaps[i] = docID -> {
                if (liveDocs == null) {
                    return docBase + docID;
                }
                if (liveDocs.get(docID)) {
                    return docBase + (int)delDocMap.get(docID);
                }
                return -1;
            };
            totalDocs += reader.numDocs();
        }
        return docMaps;
    }

    private DocMap[] buildDocMaps(List<CodecReader> readers, Sort indexSort) throws IOException {
        if (indexSort == null) {
            return this.buildDeletionDocMaps(readers);
        }
        long t0 = System.nanoTime();
        DocMap[] result = MultiSorter.sort(indexSort, readers);
        if (result == null) {
            return this.buildDeletionDocMaps(readers);
        }
        this.needsIndexSort = true;
        long t1 = System.nanoTime();
        if (this.infoStream.isEnabled("SM")) {
            this.infoStream.message("SM", String.format(Locale.ROOT, "%.2f msec to build merge sorted DocMaps", (double)(t1 - t0) / (double)TimeUnit.MILLISECONDS.toNanos(1L)));
        }
        return result;
    }

    private static void verifyIndexSort(List<CodecReader> readers, SegmentInfo segmentInfo) {
        Sort indexSort = segmentInfo.getIndexSort();
        if (indexSort == null) {
            return;
        }
        for (CodecReader leaf : readers) {
            Sort segmentSort = leaf.getMetaData().sort();
            if (segmentSort != null && IndexWriter.isCongruentSort(indexSort, segmentSort)) continue;
            throw new IllegalArgumentException("index sort mismatch: merged segment has sort=" + String.valueOf(indexSort) + " but to-be-merged segment has sort=" + String.valueOf(segmentSort == null ? "null" : segmentSort));
        }
    }

    static PackedLongValues removeDeletes(int maxDoc, Bits liveDocs) {
        PackedLongValues.Builder docMapBuilder = PackedLongValues.monotonicBuilder(0.0f);
        int del = 0;
        for (int i = 0; i < maxDoc; ++i) {
            docMapBuilder.add(i - del);
            if (liveDocs.get(i)) continue;
            ++del;
        }
        return docMapBuilder.build();
    }

    public MergeState(DocMap[] docMaps, SegmentInfo segmentInfo, FieldInfos mergeFieldInfos, StoredFieldsReader[] storedFieldsReaders, TermVectorsReader[] termVectorsReaders, NormsProducer[] normsProducers, DocValuesProducer[] docValuesProducers, FieldInfos[] fieldInfos, Bits[] liveDocs, FieldsProducer[] fieldsProducers, PointsReader[] pointsReaders, KnnVectorsReader[] knnVectorsReaders, int[] maxDocs, InfoStream infoStream, Executor intraMergeTaskExecutor, boolean needsIndexSort) {
        this.docMaps = docMaps;
        this.segmentInfo = segmentInfo;
        this.mergeFieldInfos = mergeFieldInfos;
        this.storedFieldsReaders = storedFieldsReaders;
        this.termVectorsReaders = termVectorsReaders;
        this.normsProducers = normsProducers;
        this.docValuesProducers = docValuesProducers;
        this.fieldInfos = fieldInfos;
        this.liveDocs = liveDocs;
        this.fieldsProducers = fieldsProducers;
        this.pointsReaders = pointsReaders;
        this.knnVectorsReaders = knnVectorsReaders;
        this.maxDocs = maxDocs;
        this.infoStream = infoStream;
        this.intraMergeTaskExecutor = intraMergeTaskExecutor;
        this.needsIndexSort = needsIndexSort;
    }

    @FunctionalInterface
    public static interface DocMap {
        public int get(int var1);
    }
}

