/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103;

import java.io.IOException;
import org.apache.lucene.codecs.lucene103.ForDeltaUtil;
import org.apache.lucene.codecs.lucene103.ForUtil;
import org.apache.lucene.internal.vectorization.PostingDecodingUtil;
import org.apache.lucene.internal.vectorization.VectorizationProvider;
import org.apache.lucene.store.IndexInput;

public final class PostingIndexInput {
    private static final VectorizationProvider VECTORIZATION_PROVIDER = VectorizationProvider.getInstance();
    public final ForUtil forUtil;
    public final ForDeltaUtil forDeltaUtil;
    private final PostingDecodingUtil postingDecodingUtil;

    public PostingIndexInput(IndexInput in, ForUtil forUtil, ForDeltaUtil forDeltaUtil) throws IOException {
        this.forUtil = forUtil;
        this.forDeltaUtil = forDeltaUtil;
        this.postingDecodingUtil = VECTORIZATION_PROVIDER.newPostingDecodingUtil(in);
    }

    public void decode(int bitsPerValue, int[] ints) throws IOException {
        this.forUtil.decode(bitsPerValue, this.postingDecodingUtil, ints);
    }

    public void decodeAndPrefixSum(int bitsPerValue, int base, int[] ints) throws IOException {
        this.forDeltaUtil.decodeAndPrefixSum(bitsPerValue, this.postingDecodingUtil, base, ints);
    }
}

