/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;

public abstract class KnnVectorsReader
implements Closeable {
    protected KnnVectorsReader() {
    }

    public abstract void checkIntegrity() throws IOException;

    public abstract FloatVectorValues getFloatVectorValues(String var1) throws IOException;

    public abstract ByteVectorValues getByteVectorValues(String var1) throws IOException;

    public abstract void search(String var1, float[] var2, KnnCollector var3, AcceptDocs var4) throws IOException;

    public abstract void search(String var1, byte[] var2, KnnCollector var3, AcceptDocs var4) throws IOException;

    public KnnVectorsReader getMergeInstance() throws IOException {
        return this;
    }

    public void finishMerge() throws IOException {
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return Map.of();
    }

    public static Map<String, Long> mergeOffHeapByteSizeMaps(Map<String, Long> map1, Map<String, Long> map2) {
        return Stream.of(map1, map2).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum));
    }
}

