/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.tests.util.TestUtil;

public abstract class BaseDirectoryWrapper
extends FilterDirectory {
    private boolean checkIndexOnClose = true;
    private int levelForCheckOnClose = 3;
    protected volatile boolean isOpen = true;

    protected BaseDirectoryWrapper(Directory delegate) {
        super(delegate);
    }

    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            if (this.checkIndexOnClose && DirectoryReader.indexExists((Directory)this)) {
                TestUtil.checkIndex((Directory)this, this.levelForCheckOnClose);
            }
        }
        super.close();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCheckIndexOnClose(boolean value) {
        this.checkIndexOnClose = value;
    }

    public boolean getCheckIndexOnClose() {
        return this.checkIndexOnClose;
    }

    public void setCrossCheckTermVectorsOnClose(boolean value) {
        this.levelForCheckOnClose = value ? 3 : 2;
    }

    public int getLevelForCheckOnClose() {
        return this.levelForCheckOnClose;
    }
}

