/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoWideNorthRectangle
extends GeoBaseBBox {
    protected final double bottomLat;
    protected final double leftLon;
    protected final double rightLon;
    protected final double cosMiddleLat;
    protected final GeoPoint LRHC;
    protected final GeoPoint LLHC;
    protected final SidedPlane bottomPlane;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final GeoPoint[] bottomPlanePoints;
    protected final GeoPoint[] leftPlanePoints;
    protected final GeoPoint[] rightPlanePoints;
    protected final GeoPoint centerPoint;
    protected final EitherBound eitherBound;
    protected final GeoPoint[] edgePoints;

    public GeoWideNorthRectangle(PlanetModel planetModel, double bottomLat, double leftLon, double rightLon) {
        super(planetModel);
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent < 3.1415926535866516) {
            throw new IllegalArgumentException("Width of rectangle too small");
        }
        this.bottomLat = bottomLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.LRHC = new GeoPoint(planetModel, sinBottomLat, sinRightLon, cosBottomLat, cosRightLon, bottomLat, rightLon);
        this.LLHC = new GeoPoint(planetModel, sinBottomLat, sinLeftLon, cosBottomLat, cosLeftLon, bottomLat, leftLon);
        double middleLat = (1.5707963267948966 + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, planetModel, sinBottomLat);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.bottomPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
        this.leftPlanePoints = new GeoPoint[]{planetModel.NORTH_POLE, this.LLHC};
        this.rightPlanePoints = new GeoPoint[]{planetModel.NORTH_POLE, this.LRHC};
        this.eitherBound = new EitherBound();
        this.edgePoints = new GeoPoint[]{planetModel.NORTH_POLE};
    }

    public GeoWideNorthRectangle(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.bottomLat);
        SerializableObject.writeDouble(outputStream, this.leftLon);
        SerializableObject.writeDouble(outputStream, this.rightLon);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = 1.5707963267948966;
        double newBottomLat = this.bottomLat - angle;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.bottomPlane.isWithin(x, y, z) && (this.leftPlane.isWithin(x, y, z) || this.rightPlane.isWithin(x, y, z));
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double bottomAngle = this.centerPoint.arcDistance(this.LLHC);
        return Math.max(centerAngle, bottomAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.bottomPlane, notablePoints, this.bottomPlanePoints, bounds, this.eitherBound) || p.intersects(this.planetModel, this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.bottomPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.bottomPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.bottomPlane, this.bottomPlanePoints, this.eitherBound) || geoShape.intersects(this.leftPlane, this.leftPlanePoints, this.bottomPlane) || geoShape.intersects(this.rightPlane, this.rightPlanePoints, this.bottomPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.isWide().addHorizontalPlane(this.planetModel, this.bottomLat, this.bottomPlane, this.eitherBound).addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.bottomPlane).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.bottomPlane).addIntersection(this.planetModel, this.leftPlane, this.rightPlane, this.bottomPlane).addPoint(this.LLHC).addPoint(this.LRHC).addPoint(this.planetModel.NORTH_POLE);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double bottomDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.bottomPlane, x, y, z, this.eitherBound);
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.bottomPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.bottomPlane);
        double LRHCDistance = distanceStyle.computeDistance(this.LRHC, x, y, z);
        double LLHCDistance = distanceStyle.computeDistance(this.LLHC, x, y, z);
        return Math.min(Math.min(bottomDistance, Math.min(leftDistance, rightDistance)), Math.min(LRHCDistance, LLHCDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWideNorthRectangle)) {
            return false;
        }
        GeoWideNorthRectangle other = (GeoWideNorthRectangle)o;
        return super.equals(other) && other.LLHC.equals(this.LLHC) && other.LRHC.equals(this.LRHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.LLHC.hashCode();
        result = 31 * result + this.LRHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoWideNorthRectangle: {planetmodel=" + String.valueOf(this.planetModel) + ", bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }

    protected class EitherBound
    implements Membership {
        @Override
        public boolean isWithin(Vector v) {
            return GeoWideNorthRectangle.this.leftPlane.isWithin(v) || GeoWideNorthRectangle.this.rightPlane.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return GeoWideNorthRectangle.this.leftPlane.isWithin(x, y, z) || GeoWideNorthRectangle.this.rightPlane.isWithin(x, y, z);
        }
    }
}

