/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.Position;
import org.apache.juneau.parser.Positionable;

public class ParserPipe
implements Closeable {
    private final Object input;
    final boolean debug;
    final boolean strict;
    final boolean autoCloseStreams;
    final boolean unbuffered;
    private final Charset charset;
    private String inputString;
    private InputStream inputStream;
    private Reader reader;
    private ParserReader parserReader;
    private boolean doClose;
    private BinaryFormat binaryFormat;
    private Positionable positionable;

    public ParserPipe(Object input) {
        this(input, false, false, false, false, null, null);
    }

    public ParserPipe(Object input, boolean debug, boolean autoCloseStreams, boolean unbuffered, BinaryFormat binaryFormat) {
        this.input = input;
        this.debug = debug;
        this.strict = false;
        this.autoCloseStreams = autoCloseStreams;
        this.unbuffered = unbuffered;
        this.charset = null;
        if (input instanceof CharSequence) {
            CharSequence input2 = (CharSequence)input;
            this.inputString = input2.toString();
        }
        this.binaryFormat = binaryFormat;
    }

    public ParserPipe(Object input, boolean debug, boolean strict, boolean autoCloseStreams, boolean unbuffered, Charset streamCharset, Charset fileCharset) {
        Charset cs;
        boolean isFile = input instanceof File;
        this.input = input;
        this.debug = debug;
        this.strict = strict;
        this.autoCloseStreams = autoCloseStreams;
        this.unbuffered = unbuffered;
        Charset charset = cs = isFile ? fileCharset : streamCharset;
        if (cs == null) {
            cs = isFile ? Charset.defaultCharset() : IoUtils.UTF8;
        }
        this.charset = cs;
        if (input instanceof CharSequence) {
            CharSequence cs2 = (CharSequence)input;
            this.inputString = cs2.toString();
        }
        this.binaryFormat = null;
    }

    public String asString() throws IOException {
        if (this.inputString == null) {
            this.inputString = IoUtils.read((Reader)this.getReader());
        }
        return this.inputString;
    }

    @Override
    public void close() {
        try {
            if (this.doClose) {
                IoUtils.close((Object[])new Object[]{this.reader, this.inputStream});
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.bex((Throwable)e);
        }
    }

    public Reader getBufferedReader() throws IOException {
        return IoUtils.toBufferedReader((Reader)this.getReader());
    }

    public String getInputAsString() {
        return this.inputString;
    }

    public InputStream getInputStream() throws IOException {
        if (this.input == null) {
            return null;
        }
        Object object = this.input;
        if (object instanceof InputStream) {
            InputStream input2 = (InputStream)object;
            if (this.debug) {
                b = IoUtils.readBytes((InputStream)input2);
                this.inputString = StringUtils.toHex((byte[])b);
                this.inputStream = new ByteArrayInputStream((byte[])b);
            } else {
                this.inputStream = input2;
                this.doClose = this.autoCloseStreams;
            }
        } else if (this.input instanceof byte[]) {
            if (this.debug) {
                this.inputString = StringUtils.toHex((byte[])((byte[])this.input));
            }
            this.inputStream = new ByteArrayInputStream((byte[])this.input);
            this.doClose = false;
        } else {
            b = this.input;
            if (b instanceof String) {
                String input2;
                this.inputString = input2 = (String)b;
                this.inputStream = new ByteArrayInputStream(this.convertFromString(input2));
                this.doClose = false;
            } else {
                b = this.input;
                if (b instanceof File) {
                    File input2 = (File)b;
                    if (this.debug) {
                        b = IoUtils.readBytes((File)input2);
                        this.inputString = StringUtils.toHex((byte[])b);
                        this.inputStream = new ByteArrayInputStream((byte[])b);
                    } else {
                        this.inputStream = new FileInputStream(input2);
                        this.doClose = true;
                    }
                } else {
                    throw ThrowableUtils.ioex((String)"Cannot convert object of type {0} to an InputStream.", (Object[])new Object[]{Utils.cn((Object)this.input)});
                }
            }
        }
        return this.inputStream;
    }

    public ParserReader getParserReader() throws IOException {
        ParserReader input2;
        if (this.input == null) {
            return null;
        }
        Object object = this.input;
        this.parserReader = object instanceof ParserReader ? (input2 = (ParserReader)object) : new ParserReader(this);
        return this.parserReader;
    }

    public Reader getReader() throws IOException {
        if (this.input == null) {
            return null;
        }
        Object object = this.input;
        if (object instanceof Reader) {
            Reader input2 = (Reader)object;
            if (this.debug) {
                this.inputString = IoUtils.read((Reader)input2);
                this.reader = new StringReader(this.inputString);
            } else {
                this.reader = input2;
                this.doClose = this.autoCloseStreams;
            }
        } else {
            object = this.input;
            if (object instanceof CharSequence) {
                CharSequence input2 = (CharSequence)object;
                this.inputString = input2.toString();
                this.reader = new ParserReader(this);
                this.doClose = false;
            } else if (this.input instanceof InputStream || this.input instanceof byte[]) {
                InputStream inputStream;
                this.doClose = this.input instanceof InputStream && this.autoCloseStreams;
                Object object2 = this.input;
                if (object2 instanceof InputStream) {
                    InputStream input2 = (InputStream)object2;
                    inputStream = input2;
                } else {
                    inputStream = new ByteArrayInputStream((byte[])this.input);
                }
                is = inputStream;
                CharsetDecoder cd = this.charset.newDecoder();
                if (this.strict) {
                    cd.onMalformedInput(CodingErrorAction.REPORT);
                    cd.onUnmappableCharacter(CodingErrorAction.REPORT);
                } else {
                    cd.onMalformedInput(CodingErrorAction.REPLACE);
                    cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                this.reader = new InputStreamReader((InputStream)is, cd);
                if (this.debug) {
                    this.inputString = IoUtils.read((Reader)this.reader);
                    this.reader = new StringReader(this.inputString);
                }
            } else {
                is = this.input;
                if (is instanceof File) {
                    File input2 = (File)is;
                    CharsetDecoder cd = this.charset.newDecoder();
                    if (this.strict) {
                        cd.onMalformedInput(CodingErrorAction.REPORT);
                        cd.onUnmappableCharacter(CodingErrorAction.REPORT);
                    } else {
                        cd.onMalformedInput(CodingErrorAction.REPLACE);
                        cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
                    }
                    this.reader = new InputStreamReader((InputStream)new FileInputStream(input2), cd);
                    if (this.debug) {
                        this.inputString = IoUtils.read((Reader)this.reader);
                        this.reader = new StringReader(this.inputString);
                    }
                    this.doClose = true;
                } else {
                    throw ThrowableUtils.ioex((String)"Cannot convert object of type {0} to an InputStream.", (Object[])new Object[]{Utils.cn((Object)this.input)});
                }
            }
        }
        return this.reader;
    }

    public boolean isString() {
        return Utils.nn((Object)this.inputString);
    }

    public void setPositionable(Positionable positionable) {
        this.positionable = positionable;
    }

    private byte[] convertFromString(String in) {
        return switch (this.binaryFormat) {
            case BinaryFormat.BASE64 -> StringUtils.base64Decode((String)in);
            case BinaryFormat.HEX -> StringUtils.fromHex((String)in);
            case BinaryFormat.SPACED_HEX -> StringUtils.fromSpacedHex((String)in);
            default -> new byte[]{};
        };
    }

    Position getPosition() {
        if (this.positionable == null) {
            return Position.UNKNOWN;
        }
        Position p = this.positionable.getPosition();
        if (p == null) {
            return Position.UNKNOWN;
        }
        return p;
    }
}

