/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.function.Supplier;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParseException;

@Bean
public class UriContext {
    public static final UriContext DEFAULT = new UriContext();
    public final String authority;
    public final String contextRoot;
    public final String servletPath;
    public final String pathInfo;
    public final String parentPath;
    private final Supplier<String> aContextRoot;
    private final Supplier<String> rContextRoot;
    private final Supplier<String> aServletPath;
    private final Supplier<String> rResource;
    private final Supplier<String> aPathInfo;
    private final Supplier<String> rPath;

    public static UriContext of(String s) {
        try {
            return new UriContext(s);
        }
        catch (ParseException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public static UriContext of(String authority, String contextRoot, String servletPath, String pathInfo) {
        return new UriContext(authority, contextRoot, servletPath, pathInfo);
    }

    private static String getParent(String uri) {
        int i = uri.lastIndexOf(47);
        if (i <= 1) {
            return "/";
        }
        return uri.substring(0, i);
    }

    public UriContext() {
        this(null, null, null, null);
    }

    public UriContext(String s) throws ParseException {
        JsonMap m = JsonMap.ofJson(s);
        this.authority = Utils.nullIfEmpty(StringUtils.trimSlashes(m.getString("authority")));
        this.contextRoot = Utils.nullIfEmpty(StringUtils.trimSlashes(m.getString("contextRoot")));
        this.servletPath = Utils.nullIfEmpty(StringUtils.trimSlashes(m.getString("servletPath")));
        this.pathInfo = Utils.nullIfEmpty(StringUtils.trimSlashes(m.getString("pathInfo")));
        this.parentPath = this.pathInfo == null || this.pathInfo.indexOf(47) == -1 ? null : this.pathInfo.substring(0, this.pathInfo.lastIndexOf(47));
        this.rContextRoot = Utils.mem(() -> this.findRContextRoot());
        this.rResource = Utils.mem(() -> this.findRResource());
        this.rPath = Utils.mem(() -> this.findRPath());
        this.aContextRoot = Utils.mem(() -> this.findAContextRoot());
        this.aServletPath = Utils.mem(() -> this.findAServletPath());
        this.aPathInfo = Utils.mem(() -> this.findAPathInfo());
    }

    @Beanc
    public UriContext(@Name(value="authority") String authority, @Name(value="contextRoot") String contextRoot, @Name(value="servletPath") String servletPath, @Name(value="pathInfo") String pathInfo) {
        this.authority = Utils.nullIfEmpty(StringUtils.trimSlashes(authority));
        this.contextRoot = Utils.nullIfEmpty(StringUtils.trimSlashes(contextRoot));
        this.servletPath = Utils.nullIfEmpty(StringUtils.trimSlashes(servletPath));
        this.pathInfo = Utils.nullIfEmpty(StringUtils.trimSlashes(pathInfo));
        this.parentPath = this.pathInfo == null || this.pathInfo.indexOf(47) == -1 ? null : this.pathInfo.substring(0, this.pathInfo.lastIndexOf(47));
        this.rContextRoot = Utils.mem(() -> this.findRContextRoot());
        this.rResource = Utils.mem(() -> this.findRResource());
        this.rPath = Utils.mem(() -> this.findRPath());
        this.aContextRoot = Utils.mem(() -> this.findAContextRoot());
        this.aServletPath = Utils.mem(() -> this.findAServletPath());
        this.aPathInfo = Utils.mem(() -> this.findAPathInfo());
    }

    private String findRContextRoot() {
        return this.contextRoot == null ? "/" : "/" + this.contextRoot;
    }

    private String findRResource() {
        if (this.contextRoot == null) {
            return this.servletPath == null ? "/" : "/" + this.servletPath;
        }
        return this.servletPath == null ? "/" + this.contextRoot : "/" + this.contextRoot + "/" + this.servletPath;
    }

    private String findRPath() {
        if (this.contextRoot == null) {
            if (this.servletPath == null) {
                return this.pathInfo == null ? "/" : "/" + this.pathInfo;
            }
            return this.pathInfo == null ? "/" + this.servletPath : "/" + this.servletPath + "/" + this.pathInfo;
        }
        if (this.servletPath == null) {
            return this.pathInfo == null ? "/" + this.contextRoot : "/" + this.contextRoot + "/" + this.pathInfo;
        }
        return this.pathInfo == null ? "/" + this.contextRoot + "/" + this.servletPath : "/" + this.contextRoot + "/" + this.servletPath + "/" + this.pathInfo;
    }

    private String findAContextRoot() {
        if (this.authority == null) {
            return this.rContextRoot.get();
        }
        return this.contextRoot == null ? this.authority : this.authority + "/" + this.contextRoot;
    }

    private String findAServletPath() {
        if (this.authority == null) {
            return this.rResource.get();
        }
        if (this.contextRoot == null) {
            return this.servletPath == null ? this.authority : this.authority + "/" + this.servletPath;
        }
        return this.servletPath == null ? this.authority + "/" + this.contextRoot : this.authority + "/" + this.contextRoot + "/" + this.servletPath;
    }

    private String findAPathInfo() {
        if (this.authority == null) {
            return this.rPath.get();
        }
        if (this.contextRoot == null) {
            if (this.servletPath == null) {
                return this.pathInfo == null ? this.authority : this.authority + "/" + this.pathInfo;
            }
            return this.pathInfo == null ? this.authority + "/" + this.servletPath : this.authority + "/" + this.servletPath + "/" + this.pathInfo;
        }
        if (this.servletPath == null) {
            return this.pathInfo == null ? this.authority + "/" + this.contextRoot : this.authority + "/" + this.contextRoot + "/" + this.pathInfo;
        }
        return this.pathInfo == null ? this.authority + "/" + this.contextRoot + "/" + this.servletPath : this.authority + "/" + this.contextRoot + "/" + this.servletPath + "/" + this.pathInfo;
    }

    public String getAbsoluteAuthority() {
        return this.authority == null ? "/" : this.authority;
    }

    public String getAbsoluteContextRoot() {
        return this.aContextRoot.get();
    }

    public String getAbsolutePathInfo() {
        return this.aPathInfo.get();
    }

    public String getAbsolutePathInfoParent() {
        return UriContext.getParent(this.getAbsolutePathInfo());
    }

    public String getAbsoluteServletPath() {
        return this.aServletPath.get();
    }

    public String getAbsoluteServletPathParent() {
        return UriContext.getParent(this.getAbsoluteServletPath());
    }

    public String getRootRelativeContextRoot() {
        return this.rContextRoot.get();
    }

    public String getRootRelativePathInfo() {
        return this.rPath.get();
    }

    public String getRootRelativePathInfoParent() {
        return UriContext.getParent(this.getRootRelativePathInfo());
    }

    public String getRootRelativeServletPath() {
        return this.rResource.get();
    }

    public String getRootRelativeServletPathParent() {
        return UriContext.getParent(this.getRootRelativeServletPath());
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("aContextRoot", this.aContextRoot.get()).a("aPathInfo", this.aPathInfo.get()).a("aServletPath", this.aServletPath.get()).a("authority", this.authority).a("contextRoot", this.contextRoot).a("parentPath", this.parentPath).a("pathInfo", this.pathInfo).a("rContextRoot", this.rContextRoot.get()).a("rResource", this.rResource.get()).a("servletPath", this.servletPath).a("rPath", this.rPath.get());
    }

    public String toString() {
        return Utils.r(this.properties());
    }
}

