/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;

public class BasicCsvHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String[] value;
    private final Supplier<String[]> supplier;

    public static BasicCsvHeader of(String name, String value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, String ... value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, Supplier<String[]> value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public BasicCsvHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.splita((String)value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, String ... value) {
        super(name, StringUtils.join((Object[])value, (String)", "));
        this.value = (String[])CollectionUtils.copyOf((Object[])value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, Supplier<String[]> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<String[]> asArray() {
        return Utils.opt((Object)((String[])CollectionUtils.copyOf((Object[])this.value())));
    }

    public Optional<List<String>> asList() {
        return Utils.opt((Object)CollectionUtils.u((List)CollectionUtils.l((Object[])this.value())));
    }

    public FluentListAssertion<String, BasicCsvHeader> assertList() {
        return new FluentListAssertion(CollectionUtils.u((List)CollectionUtils.l((Object[])this.value())), (Object)this);
    }

    public boolean contains(String val) {
        String[] value2;
        if (Utils.nn((Object)this.value)) {
            for (String v : this.value) {
                if (!Utils.eq((Object)v, (Object)val)) continue;
                return true;
            }
        }
        if (Utils.nn(this.supplier) && Utils.nn((Object)(value2 = this.supplier.get()))) {
            for (String v : this.supplier.get()) {
                if (!Utils.eq((Object)v, (Object)val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        String[] value2;
        if (Utils.nn((Object)this.value)) {
            for (String v : this.value) {
                if (!Utils.eqic((String)v, (String)val)) continue;
                return true;
            }
        }
        if (Utils.nn(this.supplier) && Utils.nn((Object)(value2 = this.supplier.get()))) {
            for (String v : this.supplier.get()) {
                if (!Utils.eqic((String)v, (String)val)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValue() {
        return StringUtils.join((Object[])this.value(), (String)", ");
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public String[] toArray() {
        return (String[])CollectionUtils.copyOf((Object[])this.value());
    }

    public List<String> toList() {
        return CollectionUtils.u((List)CollectionUtils.l((Object[])this.value()));
    }

    private String[] value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

