/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.assertion;

import java.io.PrintStream;
import java.lang.reflect.Type;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.rest.client.ResponseContent;
import org.apache.juneau.rest.client.RestCallException;

public class FluentResponseBodyAssertion<R>
extends FluentObjectAssertion<ResponseContent, R> {
    public FluentResponseBodyAssertion(Assertion creator, ResponseContent value, R returns) {
        super(creator, value, returns);
        this.setThrowable(BadRequest.class);
    }

    public FluentResponseBodyAssertion(ResponseContent value, R returns) {
        this((Assertion)null, value, returns);
    }

    public <T> FluentAnyAssertion<T, R> as(Class<T> type) {
        return new FluentAnyAssertion(this.valueAsType(type, new Type[0]), this.returns());
    }

    public FluentAnyAssertion<Object, R> as(Type type, Type ... args) {
        return new FluentAnyAssertion(this.valueAsType(type, args), this.returns());
    }

    public FluentByteArrayAssertion<R> asBytes() {
        return new FluentByteArrayAssertion(this.valueAsBytes(), this.returns());
    }

    @Override
    public FluentStringAssertion<R> asString() {
        return new FluentStringAssertion(this.valueAsString(), this.returns());
    }

    @Override
    public R is(String value) throws AssertionError {
        return this.asString().is(value);
    }

    public R isContains(String ... values) throws AssertionError {
        return this.asString().isContains(values);
    }

    public R isEmpty() {
        return this.asString().isEmpty();
    }

    public R isNotContains(String ... values) throws AssertionError {
        return this.asString().isNotContains(values);
    }

    public R isNotEmpty() {
        return this.asString().isNotEmpty();
    }

    @Override
    public FluentResponseBodyAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentResponseBodyAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentResponseBodyAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentResponseBodyAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentResponseBodyAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private byte[] valueAsBytes() throws AssertionError {
        try {
            return ((ResponseContent)this.value()).cache().asBytes();
        }
        catch (RestCallException e) {
            throw this.error((Throwable)((Object)e), "Exception occurred during call.", new Object[0]);
        }
    }

    private <T> T valueAsType(Type type, Type ... args) throws AssertionError {
        try {
            return ((ResponseContent)this.value()).cache().as(type, args);
        }
        catch (RestCallException e) {
            throw this.error((Throwable)((Object)e), "Exception occurred during call.", new Object[0]);
        }
    }

    @Override
    protected String valueAsString() throws AssertionError {
        try {
            return ((ResponseContent)this.value()).cache().asString();
        }
        catch (RestCallException e) {
            throw this.error((Throwable)((Object)e), "Exception occurred during call.", new Object[0]);
        }
    }
}

