/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb1.lib.NodeLib;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.Hash;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import tdb.cmdline.CmdTDB;

public class tdbnode
extends CmdTDB {
    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbnode(argv).mainRun();
    }

    protected tdbnode(String[] argv) {
        super(argv);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " NodeId ...";
    }

    @Override
    protected void exec() {
        DatasetGraphTDB dsg = this.getDatasetGraphTDB();
        NodeTable nodeTable = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        Iterator<String> iter = super.getPositional().iterator();
        if (!iter.hasNext()) {
            System.err.println("No node ids");
            return;
        }
        while (iter.hasNext()) {
            String id = iter.next();
            try {
                long x = Long.parseLong(id);
                NodeId nodeId = new NodeId(x);
                Node n = nodeTable.getNodeForNodeId(nodeId);
                Hash h = new Hash(16);
                NodeLib.setHash(h, n);
                String str2 = Bytes.asHex(h.getBytes());
                System.out.printf("%s %08d 0x%s # %s\n", id, x, str2, n);
            }
            catch (Exception ex) {
                System.out.println("Failed to decode: " + id);
            }
        }
    }
}

