/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.CachingMatchesIterator;
import org.apache.lucene.queries.intervals.DisiPriorityQueue;
import org.apache.lucene.queries.intervals.DisiWrapper;
import org.apache.lucene.queries.intervals.DisjunctionDISIApproximation;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatches;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalQuery;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.intervals.MinimizingConjunctionIntervalsSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.PriorityQueue;

class MinimumShouldMatchIntervalsSource
extends IntervalsSource {
    private final IntervalsSource[] sources;
    private final int minShouldMatch;

    MinimumShouldMatchIntervalsSource(IntervalsSource[] sources, int minShouldMatch) {
        assert (minShouldMatch < sources.length);
        this.sources = sources;
        this.minShouldMatch = minShouldMatch;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        ArrayList<IntervalIterator> iterators = new ArrayList<IntervalIterator>();
        for (IntervalsSource source : this.sources) {
            IntervalIterator it = source.intervals(field, ctx);
            if (it == null) continue;
            iterators.add(it);
        }
        if (iterators.size() < this.minShouldMatch) {
            return null;
        }
        return new MinimumShouldMatchIntervalIterator(iterators, this.minShouldMatch, () -> {});
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        IdentityHashMap<IntervalIterator, CachingMatchesIterator> lookup = new IdentityHashMap<IntervalIterator, CachingMatchesIterator>();
        for (IntervalsSource source : this.sources) {
            IntervalMatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) continue;
            CachingMatchesIterator cmi = new CachingMatchesIterator(mi);
            lookup.put(IntervalMatches.wrapMatches(cmi, doc), cmi);
        }
        if (lookup.size() < this.minShouldMatch) {
            return null;
        }
        MinimumShouldMatchIntervalIterator it = new MinimumShouldMatchIntervalIterator(lookup.keySet(), this.minShouldMatch, MinimizingConjunctionIntervalsSource.cacheIterators(lookup.values()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new MinimumMatchesIterator(it, lookup);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        IntervalQuery parent = new IntervalQuery(field, this);
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, parent);
        for (IntervalsSource source : this.sources) {
            source.visit(field, v);
        }
    }

    @Override
    public int minExtent() {
        int[] subExtents = new int[this.sources.length];
        for (int i = 0; i < subExtents.length; ++i) {
            subExtents[i] = this.sources[i].minExtent();
        }
        Arrays.sort(subExtents);
        int minExtent = 0;
        for (int i = 0; i < this.minShouldMatch; ++i) {
            minExtent += subExtents[i];
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public String toString() {
        return "AtLeast(" + Arrays.stream(this.sources).map(IntervalsSource::toString).collect(Collectors.joining(",")) + "~" + this.minShouldMatch + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinimumShouldMatchIntervalsSource that = (MinimumShouldMatchIntervalsSource)o;
        return this.minShouldMatch == that.minShouldMatch && Arrays.equals(this.sources, that.sources);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.minShouldMatch);
        result = 31 * result + Arrays.hashCode(this.sources);
        return result;
    }

    static class MinimumMatchesIterator
    implements IntervalMatchesIterator {
        boolean cached = true;
        final MinimumShouldMatchIntervalIterator iterator;
        final Map<IntervalIterator, CachingMatchesIterator> lookup;

        MinimumMatchesIterator(MinimumShouldMatchIntervalIterator iterator, Map<IntervalIterator, CachingMatchesIterator> lookup) {
            this.iterator = iterator;
            this.lookup = lookup;
        }

        @Override
        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        @Override
        public int startPosition() {
            return this.iterator.start();
        }

        @Override
        public int endPosition() {
            return this.iterator.end();
        }

        @Override
        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get(it);
                start = Math.min(start, cms.startOffset());
            }
            return start;
        }

        @Override
        public int endOffset() throws IOException {
            int end = 0;
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get(it);
                end = Math.max(end, cms.endOffset());
            }
            return end;
        }

        @Override
        public int gaps() {
            return this.iterator.gaps();
        }

        @Override
        public int width() {
            return this.iterator.width();
        }

        @Override
        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
            for (IntervalIterator it : this.iterator.getCurrentIterators()) {
                CachingMatchesIterator cms = this.lookup.get(it);
                MatchesIterator mi = cms.getSubMatches();
                mis.add(mi == null ? cms : mi);
            }
            return MatchesUtils.disjunction(mis);
        }

        @Override
        public Query getQuery() {
            return null;
        }
    }

    static class MinimumShouldMatchIntervalIterator
    extends IntervalIterator {
        private final DocIdSetIterator approximation;
        private final DisiPriorityQueue disiQueue;
        private final PriorityQueue<IntervalIterator> proximityQueue;
        private final PriorityQueue<IntervalIterator> backgroundQueue;
        private final float matchCost;
        private final int minShouldMatch;
        private final Collection<IntervalIterator> currentIterators = new ArrayList<IntervalIterator>();
        private final MinimizingConjunctionIntervalsSource.MatchCallback onMatch;
        private int start;
        private int end;
        private int queueEnd;
        private int slop;
        private IntervalIterator lead;

        MinimumShouldMatchIntervalIterator(Collection<IntervalIterator> subs, int minShouldMatch, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
            this.disiQueue = new DisiPriorityQueue(subs.size());
            float mc = 0.0f;
            for (IntervalIterator it : subs) {
                this.disiQueue.add(new DisiWrapper(it));
                mc += it.matchCost();
            }
            this.approximation = new DisjunctionDISIApproximation(this.disiQueue);
            this.matchCost = mc;
            this.minShouldMatch = minShouldMatch;
            this.onMatch = onMatch;
            this.proximityQueue = new PriorityQueue<IntervalIterator>(minShouldMatch){

                @Override
                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.backgroundQueue = new PriorityQueue<IntervalIterator>(subs.size()){

                @Override
                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.end() < b.end() || a.end() == b.end() && a.start() >= b.start();
                }
            };
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int gaps() {
            return this.slop;
        }

        @Override
        public int nextInterval() throws IOException {
            this.lead = null;
            while (this.proximityQueue.size() == this.minShouldMatch && this.proximityQueue.top().start() == this.start) {
                IntervalIterator it = this.proximityQueue.pop();
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.backgroundQueue.add(it);
                IntervalIterator next = this.backgroundQueue.pop();
                assert (next != null);
                this.proximityQueue.add(next);
                this.updateRightExtreme(next);
            }
            if (this.proximityQueue.size() < this.minShouldMatch) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                IntervalIterator next;
                this.onMatch.onMatch();
                this.start = this.proximityQueue.top().start();
                this.end = this.queueEnd;
                this.slop = this.width();
                for (IntervalIterator it : this.proximityQueue) {
                    this.slop -= it.width();
                }
                if (this.proximityQueue.top().end() == this.end) {
                    return this.start;
                }
                this.lead = this.proximityQueue.pop();
                if (this.lead == null) continue;
                if (this.lead.nextInterval() != Integer.MAX_VALUE) {
                    this.backgroundQueue.add(this.lead);
                }
                if ((next = this.backgroundQueue.pop()) == null) continue;
                this.proximityQueue.add(next);
                this.updateRightExtreme(next);
            } while (this.proximityQueue.size() == this.minShouldMatch && this.end == this.queueEnd);
            return this.start;
        }

        Collection<IntervalIterator> getCurrentIterators() {
            this.currentIterators.clear();
            if (this.lead != null) {
                this.currentIterators.add(this.lead);
            }
            for (IntervalIterator it : this.proximityQueue) {
                if (it.end() > this.end) continue;
                this.currentIterators.add(it);
            }
            return this.currentIterators;
        }

        private void reset() throws IOException {
            IntervalIterator it;
            this.proximityQueue.clear();
            this.backgroundQueue.clear();
            DisiWrapper dw = this.disiQueue.topList();
            while (dw != null) {
                if (dw.intervals.nextInterval() != Integer.MAX_VALUE) {
                    this.backgroundQueue.add(dw.intervals);
                }
                dw = dw.next;
            }
            this.queueEnd = -1;
            for (int i = 0; i < this.minShouldMatch && (it = this.backgroundQueue.pop()) != null; ++i) {
                this.proximityQueue.add(it);
                this.updateRightExtreme(it);
            }
            this.end = -1;
            this.start = -1;
        }

        private void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }

        @Override
        public int docID() {
            return this.approximation.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int doc = this.approximation.nextDoc();
            this.reset();
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc = this.approximation.advance(target);
            this.reset();
            return doc;
        }

        @Override
        public long cost() {
            return this.approximation.cost();
        }
    }
}

