/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.document.BinaryRangeFieldRangeQuery;
import org.apache.lucene.document.DoubleRange;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

class DoubleRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final double[] min;
    private final double[] max;

    DoubleRangeSlowRangeQuery(String field, double[] min2, double[] max2, RangeFieldQuery.QueryType queryType) {
        super(field, DoubleRangeSlowRangeQuery.encodeRanges(min2, max2), 8, min2.length, queryType);
        this.field = field;
        this.min = min2;
        this.max = max2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        DoubleRangeSlowRangeQuery that = (DoubleRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.min);
        h = 31 * h + Arrays.hashCode(this.max);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private static byte[] encodeRanges(double[] min2, double[] max2) {
        byte[] result = new byte[16 * min2.length];
        DoubleRange.verifyAndEncode(min2, max2, result);
        return result;
    }
}

