/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintEntity;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnFocusNodeEvent;
import org.apache.jena.shacl.vocabulary.SHACL;

public class HasValueConstraint
extends ConstraintEntity {
    private final Node value;

    public HasValueConstraint(Node value) {
        Objects.requireNonNull(value, "value");
        this.value = value;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public Node getComponent() {
        return SHACL.HasValueConstraintComponent;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        boolean passed = true;
        if (!focusNode.equals(this.value)) {
            passed = false;
            String errMsg = this.toString() + " : No value " + ShLib.displayStr(this.value);
            vCxt.reportEntry(errMsg, shape, focusNode, null, null, this);
        }
        boolean finalPassed = passed;
        vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnFocusNodeEvent(vCxt, shape, focusNode, this, finalPassed));
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Set<Node> pathNodes) {
        if (pathNodes.contains(this.value)) {
            return null;
        }
        String errMsg = this.toString() + " : No value " + ShLib.displayStr(this.value) + " in " + String.valueOf(pathNodes);
        return new ReportItem(errMsg, null);
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, nodeFmt, "hasValue", this.value);
    }

    public String toString() {
        return "HasValueConstraint[" + String.valueOf(this.value) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HasValueConstraint)) {
            return false;
        }
        HasValueConstraint other = (HasValueConstraint)obj;
        return Objects.equals(this.value, other.value);
    }
}

