/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.writer;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.compact.writer.ShaclNotCompactException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.constraint.MaxCount;
import org.apache.jena.shacl.engine.constraint.MinCount;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.path.Path;

public class ShapeOutputVisitor
implements ShapeVisitor {
    private final IndentedWriter out;
    private final NodeFormatter nodeFmt;
    private final Prologue prologue;

    ShapeOutputVisitor(PrefixMapping pmap, NodeFormatter nodeFmt, IndentedWriter out) {
        this(nodeFmt, out, new Prologue(pmap));
    }

    private ShapeOutputVisitor(NodeFormatter nodeFmt, IndentedWriter out, Prologue prologue) {
        this.nodeFmt = nodeFmt;
        this.out = out;
        this.prologue = prologue;
    }

    public ShapeOutputVisitor fork(IndentedWriter out) {
        return new ShapeOutputVisitor(this.nodeFmt, out, this.prologue);
    }

    @Override
    public void visit(NodeShape nodeShape) {
        boolean printingStarted = this.printTargets(nodeShape);
        this.printShapeParams(nodeShape, true, printingStarted);
        nodeShape.getConstraints().forEach(c -> this.nodeConstraint((Constraint)c));
        nodeShape.getPropertyShapes().forEach(this::outputPropertyShape);
    }

    @Override
    public void visit(PropertyShape propertyShape) {
        boolean outputStarted = false;
        Path path = propertyShape.getPath();
        ShaclPaths.write(this.out, path, this.prologue);
        outputStarted = true;
        this.printShapeParams(propertyShape, false, outputStarted);
        int minCount = -1;
        int maxCount = -1;
        for (Constraint c : propertyShape.getConstraints()) {
            if (SHACL.MinCountConstraintComponent.equals(c.getComponent())) {
                minCount = ((MinCount)c).getMinCount();
                continue;
            }
            if (!SHACL.MaxCountConstraintComponent.equals(c.getComponent())) continue;
            maxCount = ((MaxCount)c).getMaxCount();
        }
        boolean minMaxCountDone = false;
        for (Constraint c : propertyShape.getConstraints()) {
            if (SHACL.MinCountConstraintComponent.equals(c.getComponent()) || SHACL.MaxCountConstraintComponent.equals(c.getComponent())) {
                if (!(minMaxCountDone || minCount == -1 && maxCount == -1)) {
                    String minStr = minCount != -1 ? Integer.toString(minCount) : "0";
                    String maxStr = maxCount != -1 ? Integer.toString(maxCount) : "*";
                    this.out.print(" [" + minStr + ".." + maxStr + "]");
                }
                minMaxCountDone = true;
                continue;
            }
            this.out.print(" ");
            this.propertyConstraint(c);
        }
        this.out.println(" .");
        propertyShape.getPropertyShapes().forEach(this::outputPropertyShape);
    }

    private void paramPrinter(boolean forNodeShape, boolean outputStarted, Runnable action) {
        if (outputStarted) {
            this.out.println(" ");
        }
        action.run();
        if (forNodeShape) {
            this.out.println(" .");
        }
    }

    private boolean printShapeParams(Shape shape, boolean forNodeShape, boolean outputStarted) {
        if (shape.deactivated()) {
            this.paramPrinter(forNodeShape, outputStarted, () -> CompactOut.compactUnquotedString(this.out, "deactivated", "true"));
            outputStarted = true;
        }
        if (shape.getSeverity() != null && !SHACL.Violation.equals(shape.getSeverity().level())) {
            this.paramPrinter(forNodeShape, outputStarted, () -> CompactOut.compact(this.out, this.nodeFmt, "severity", shape.getSeverity().level()));
            outputStarted = true;
        }
        if (shape.getMessages() != null) {
            boolean space = outputStarted;
            for (Node msg : shape.getMessages()) {
                if (space) {
                    this.out.print(" ");
                }
                CompactOut.compact(this.out, this.nodeFmt, "message", msg);
                if (forNodeShape) {
                    this.out.println(" .");
                }
                space = true;
            }
            outputStarted = space;
        }
        return outputStarted;
    }

    private boolean printTargets(Shape shape) {
        boolean havePrinted = false;
        block8: for (Target target : shape.getTargets()) {
            switch (target.getTargetType()) {
                case implicitClass: {
                    continue block8;
                }
                case targetClass: {
                    continue block8;
                }
                case targetNode: {
                    break;
                }
                case targetObjectsOf: {
                    break;
                }
                case targetSubjectsOf: {
                    break;
                }
                case targetExtension: {
                    throw new ShaclNotCompactException("sh:target not supported in compact syntax");
                }
            }
            this.out.print(target.getTargetType().compact);
            this.out.print(" = ");
            this.nodeFmt.format(this.out, target.getObject());
            this.out.println(" .");
            havePrinted = true;
        }
        return havePrinted;
    }

    private void outputPropertyShape(PropertyShape ps) {
        ps.visit(this);
    }

    void nodeConstraint(Constraint c) {
        this.constraint(c);
        this.out.println(" .");
    }

    void propertyConstraint(Constraint c) {
        this.constraint(c);
    }

    void constraint(Constraint c) {
        c.printCompact(this.out, this.nodeFmt);
    }
}

