/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.Serializable;
import java.util.Objects;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.EltStreamRDFType;
import org.apache.jena.sparql.core.Quad;

public class EltStreamRDF
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EltStreamRDFType type;
    private final Triple triple;
    private final Quad quad;
    private final String prefix;
    private final String iri;
    private final Throwable exception;

    EltStreamRDF(Triple triple) {
        this(EltStreamRDFType.TRIPLE, triple, null, null, null, null);
    }

    EltStreamRDF(Quad quad) {
        this(EltStreamRDFType.QUAD, null, quad, null, null, null);
    }

    EltStreamRDF(String prefix, String iri2) {
        this(EltStreamRDFType.PREFIX, null, null, prefix, iri2, null);
    }

    EltStreamRDF(String iri2) {
        this(EltStreamRDFType.BASE, null, null, null, iri2, null);
    }

    EltStreamRDF(Throwable exception) {
        this(EltStreamRDFType.EXCEPTION, null, null, null, null, exception);
    }

    EltStreamRDF(EltStreamRDFType eltType, Triple triple, Quad quad, String prefix, String iri2, Throwable exception) {
        this.type = eltType;
        this.triple = triple;
        this.quad = quad;
        this.prefix = prefix;
        this.iri = iri2;
        this.exception = exception;
    }

    public boolean isTriple() {
        return EltStreamRDFType.TRIPLE.equals((Object)this.type);
    }

    public Triple triple() {
        return this.triple;
    }

    public boolean isQuad() {
        return EltStreamRDFType.QUAD.equals((Object)this.type);
    }

    public Quad quad() {
        return this.quad;
    }

    public boolean isPrefix() {
        return EltStreamRDFType.PREFIX.equals((Object)this.type);
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean isBase() {
        return EltStreamRDFType.BASE.equals((Object)this.type);
    }

    public String iri() {
        return this.iri;
    }

    public boolean isException() {
        return EltStreamRDFType.EXCEPTION.equals((Object)this.type);
    }

    public Throwable exception() {
        return this.exception;
    }

    public EltStreamRDFType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.triple, this.quad, this.prefix, this.iri, this.exception});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EltStreamRDF other = (EltStreamRDF)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.triple, other.triple) && Objects.equals(this.quad, other.quad) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.iri, other.iri) && Objects.equals(this.exception, other.exception);
    }

    public String toString() {
        return switch (this.getType()) {
            case EltStreamRDFType.TRIPLE -> "triple(" + NodeFmtLib.str(this.triple()) + ")";
            case EltStreamRDFType.QUAD -> "quad(" + NodeFmtLib.str(this.quad()) + ")";
            case EltStreamRDFType.PREFIX -> "prefix(" + Objects.toString(this.prefix() + ", " + this.iri()) + ")";
            case EltStreamRDFType.BASE -> "base(" + Objects.toString(this.iri()) + ")";
            case EltStreamRDFType.EXCEPTION -> "exception(" + Objects.toString(this.exception()) + ")";
            default -> "unknown";
        };
    }

    public static EltStreamRDF triple(Triple triple) {
        return new EltStreamRDF(Objects.requireNonNull(triple));
    }

    public static EltStreamRDF quad(Quad quad) {
        return new EltStreamRDF(Objects.requireNonNull(quad));
    }

    public static EltStreamRDF base(String iri2) {
        return new EltStreamRDF(Objects.requireNonNull(iri2));
    }

    public static EltStreamRDF prefix(String prefix, String iri2) {
        return new EltStreamRDF(Objects.requireNonNull(prefix), Objects.requireNonNull(iri2));
    }

    public static EltStreamRDF exception(Throwable exception) {
        return new EltStreamRDF(Objects.requireNonNull(exception));
    }
}

