/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.vocabulary.RDF;

public class ListLength
extends BaseBuiltin {
    @Override
    public String getName() {
        return "listLength";
    }

    @Override
    public int getArgLength() {
        return 2;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context2) {
        this.checkArgs(length, context2);
        BindingEnvironment env = context2.getEnv();
        int len = ListLength.getLength(this.getArg(0, args, context2), context2);
        if (len == -1) {
            return false;
        }
        env.bind(args[1], Util.makeIntNode(len));
        return true;
    }

    protected static int getLength(Node node, RuleContext context2) {
        if (node.equals(RDF.Nodes.nil)) {
            return 0;
        }
        Node next = Util.getPropValue(node, RDF.Nodes.rest, context2);
        if (next == null) {
            return -1;
        }
        int sublen = ListLength.getLength(next, context2);
        if (sublen == -1) {
            return -1;
        }
        return 1 + sublen;
    }
}

