/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.vocabulary.RDF;

public class ListContains
extends BaseBuiltin {
    @Override
    public String getName() {
        return "listContains";
    }

    @Override
    public int getArgLength() {
        return 2;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context2) {
        this.checkArgs(length, context2);
        Node n0 = this.getArg(0, args, context2);
        Node n1 = this.getArg(1, args, context2);
        return ListContains.listContains(n0, n1, context2);
    }

    protected static boolean listContains(Node list, Node element, RuleContext context2) {
        if (list == null || list.equals(RDF.Nodes.nil)) {
            return false;
        }
        Node elt = Util.getPropValue(list, RDF.Nodes.first, context2);
        if (elt.sameValueAs(element)) {
            return true;
        }
        Node next = Util.getPropValue(list, RDF.Nodes.rest, context2);
        return ListContains.listContains(next, element, context2);
    }
}

