/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkDatasetBuilder;
import org.apache.jena.rdflink.RDFLinkFuseki;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.rdflink.RDFLinkHTTPBuilder;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sys.JenaSystem;

public class RDFLinkFactory {
    public static RDFLink connect(String destination) {
        return RDFLinkHTTP.service(destination).build();
    }

    public static RDFLink connect(String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return RDFLinkHTTP.newBuilder().queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    public static RDFLinkHTTPBuilder newBuilder(String destination) {
        return RDFLinkHTTP.newBuilder().destination(destination);
    }

    public static RDFLink connect(String datasetURL, String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return RDFLinkHTTP.newBuilder().destination(datasetURL).queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    public static RDFLink connect(DatasetGraph dataset) {
        return RDFLinkDatasetBuilder.connect(dataset);
    }

    public static RDFLink connect(DatasetGraph dataset, Isolation isolation) {
        return RDFLinkDatasetBuilder.connect(dataset, isolation);
    }

    public static RDFLinkFuseki connectFuseki(String destination) {
        return (RDFLinkFuseki)RDFLinkFuseki.newBuilder().destination(destination).build();
    }

    public static RDFLinkFuseki connectFuseki(String datasetURL, String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return (RDFLinkFuseki)RDFLinkFuseki.newBuilder().destination(datasetURL).queryEndpoint(queryServiceEndpoint).updateEndpoint(updateServiceEndpoint).gspEndpoint(graphStoreProtocolEndpoint).build();
    }

    static {
        JenaSystem.init();
    }
}

