/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions;

import java.util.List;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.property_functions.GenericSpatialPropertyFunction;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class GenericSpatialGeomPropertyFunction
extends GenericSpatialPropertyFunction {
    private static final int GEOM_POS = 0;
    private static final int LIMIT_POS = 1;

    @Override
    protected boolean requireSecondFilter() {
        return false;
    }

    @Override
    protected SpatialArguments extractObjectArguments(Node predicate, PropFuncArg object, SRSInfo indexSRSInfo) {
        try {
            int limit;
            List<Node> objectArgs = object.getArgList();
            if (objectArgs.size() < 1) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Minimum of 1 arguments.");
            }
            if (objectArgs.size() > 2) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Maximum of 2 arguments.");
            }
            Node geomLit = object.getArg(0);
            if (objectArgs.size() > 1) {
                NodeValue limitNode = NodeValue.makeNode(objectArgs.get(1));
                if (!limitNode.isInteger()) {
                    throw new ExprEvalException("Not an integer: " + FmtUtils.stringForNode(limitNode.asNode()));
                }
                limit = limitNode.getInteger().intValue();
            } else {
                limit = -1;
            }
            GeometryWrapper geometryWrapper = GeometryWrapper.extract(geomLit);
            SearchEnvelope searchEnvelope = this.buildSearchEnvelope(geometryWrapper, indexSRSInfo);
            return new SpatialArguments(limit, geometryWrapper, searchEnvelope);
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    protected SearchEnvelope buildSearchEnvelope(GeometryWrapper geometryWrapper, SRSInfo indexSRSInfo) {
        return SearchEnvelope.build(geometryWrapper, indexSRSInfo);
    }
}

