/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.relateng.NodeSection;
import org.locationtech.jts.operation.relateng.NodeSections;
import org.locationtech.jts.operation.relateng.RelateGeometry;
import org.locationtech.jts.operation.relateng.RelateNode;

class AdjacentEdgeLocator {
    private List<Coordinate[]> ringList;

    public AdjacentEdgeLocator(Geometry geom) {
        this.init(geom);
    }

    public int locate(Coordinate p) {
        NodeSections sections = new NodeSections(p);
        for (Coordinate[] ring : this.ringList) {
            this.addSections(p, ring, sections);
        }
        RelateNode node = sections.createNode();
        return node.hasExteriorEdge(true) ? 1 : 0;
    }

    private void addSections(Coordinate p, Coordinate[] ring, NodeSections sections) {
        for (int i = 0; i < ring.length - 1; ++i) {
            Coordinate p0 = ring[i];
            Coordinate pnext = ring[i + 1];
            if (p.equals2D(pnext)) continue;
            if (p.equals2D(p0)) {
                int iprev = i > 0 ? i - 1 : ring.length - 2;
                Coordinate pprev = ring[iprev];
                sections.addNodeSection(this.createSection(p, pprev, pnext));
                continue;
            }
            if (!PointLocation.isOnSegment(p, p0, pnext)) continue;
            sections.addNodeSection(this.createSection(p, p0, pnext));
        }
    }

    private NodeSection createSection(Coordinate p, Coordinate prev, Coordinate next) {
        if (prev.distance(p) == 0.0 || next.distance(p) == 0.0) {
            System.out.println("Found zero-length section segment");
        }
        NodeSection ns = new NodeSection(true, 2, 1, 0, null, false, prev, p, next);
        return ns;
    }

    private void init(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        this.ringList = new ArrayList<Coordinate[]>();
        this.addRings(geom, this.ringList);
    }

    private void addRings(Geometry geom, List<Coordinate[]> ringList2) {
        block3: {
            block2: {
                if (!(geom instanceof Polygon)) break block2;
                Polygon poly = (Polygon)geom;
                LinearRing shell = poly.getExteriorRing();
                this.addRing(shell, true);
                for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                    LinearRing hole = poly.getInteriorRingN(i);
                    this.addRing(hole, false);
                }
                break block3;
            }
            if (!(geom instanceof GeometryCollection)) break block3;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                this.addRings(geom.getGeometryN(i), this.ringList);
            }
        }
    }

    private void addRing(LinearRing ring, boolean requireCW) {
        Coordinate[] pts = RelateGeometry.orient(ring.getCoordinates(), requireCW);
        this.ringList.add(pts);
    }
}

