/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.BitSet;
import java.util.Collection;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public final class ArgumentChecks
extends Static {
    private ArgumentChecks() {
    }

    public static void ensureNonNull(String name, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
    }

    public static void ensureNonNullElement(String name, int index, Object element) throws NullArgumentException {
        if (element == null) {
            StringBuilder buffer = new StringBuilder(name);
            int s = name.indexOf("[#]");
            if (s >= 0) {
                buffer.setLength(s + 1);
                buffer.append(index).append(name, s + 2, name.length());
            } else {
                buffer.append('[').append(index).append(']');
            }
            throw new NullArgumentException(Errors.format((short)113, buffer.toString()));
        }
    }

    public static void ensureNonEmpty(String name, CharSequence text) throws NullArgumentException, IllegalArgumentException {
        if (text == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, name));
        }
    }

    public static void ensureNonEmpty(String name, Object[] array) throws NullArgumentException, IllegalArgumentException {
        if (array == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, name));
        }
    }

    public static void ensureNonEmpty(String name, Collection<?> toCheck) {
        if (toCheck == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
        if (toCheck.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)29, name));
        }
    }

    public static void ensureNonEmpty(String name, Emptiable toCheck) {
        if (toCheck == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
        if (toCheck.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)29, name));
        }
    }

    @Deprecated(since="1.3", forRemoval=true)
    public static void ensureNonEmpty(String name, int[] values, int min2, int max2, boolean distinct) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmptyBounded(name, distinct, min2, max2, values);
    }

    public static void ensureNonEmptyBounded(String name, boolean distinct, int min2, int max2, int[] values) throws IllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException(Errors.format((short)113, name));
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, name));
        }
        long found = 0L;
        BitSet more = null;
        for (int i = 0; i < values.length; ++i) {
            int index = values[i];
            if (index < min2 || index > max2) {
                throw new IllegalArgumentException(Errors.format((short)166, Strings.toIndexed(name, i), min2, max2, index));
            }
            if (!distinct) continue;
            int flag = index - min2;
            if (flag <= 64) {
                if (found != (found |= 1L << flag)) {
                    continue;
                }
            } else {
                flag -= 64;
                if (more == null) {
                    more = new BitSet();
                }
                if (!more.get(flag)) {
                    more.set(flag);
                    continue;
                }
            }
            throw new IllegalArgumentException(Errors.format((short)187, index));
        }
    }

    @Deprecated(since="1.3", forRemoval=true)
    public static void ensureExpectedCount(String name, int expected, int actual) {
        ArgumentChecks.ensureCountBetween(name, false, expected, expected, actual);
    }

    public static void ensureCanCast(String name, Class<?> expectedType, Object value) throws IllegalArgumentException {
        Class<?> valueClass;
        if (value != null && !expectedType.isAssignableFrom(valueClass = value.getClass())) {
            Object[] args;
            short key;
            if (name != null) {
                key = 43;
                args = new Object[]{name, expectedType, valueClass};
            } else {
                key = 50;
                args = new Object[]{expectedType, valueClass};
            }
            throw new IllegalArgumentException(Errors.format(key, args));
        }
    }

    public static void ensureValidIndex(int upper, int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= upper) {
            throw new IndexOutOfBoundsException(Errors.format((short)71, index));
        }
    }

    public static void ensureValidIndexRange(int length, int lower, int upper) throws IndexOutOfBoundsException {
        if (lower < 0 || upper < lower || upper > length) {
            throw new IndexOutOfBoundsException(Errors.format((short)60, lower, upper));
        }
    }

    public static void ensurePositive(String name, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException(Errors.format((short)92, name, value));
        }
    }

    public static void ensurePositive(String name, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException(Errors.format((short)92, name, value));
        }
    }

    public static void ensurePositive(String name, float value) throws IllegalArgumentException {
        if (!(value >= 0.0f) || Float.floatToRawIntBits(value) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)92, name, Float.valueOf(value)));
        }
    }

    public static void ensurePositive(String name, double value) throws IllegalArgumentException {
        if (!(value >= 0.0) || Double.doubleToRawLongBits(value) == Long.MIN_VALUE) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)92, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, int value) throws IllegalArgumentException {
        if (value <= 0) {
            throw new IllegalArgumentException(Errors.format((short)165, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, long value) throws IllegalArgumentException {
        if (value <= 0L) {
            throw new IllegalArgumentException(Errors.format((short)165, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, float value) throws IllegalArgumentException {
        if (!(value > 0.0f)) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)165, name, Float.valueOf(value)));
        }
    }

    public static void ensureStrictlyPositive(String name, double value) throws IllegalArgumentException {
        if (!(value > 0.0)) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)165, name, value));
        }
    }

    public static void ensureFinite(String name, float value) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException(Errors.format(Float.isNaN(value) ? (short)110 : 73, name));
        }
    }

    public static void ensureFinite(String name, double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(Errors.format(Double.isNaN(value) ? (short)110 : 73, name));
        }
    }

    public static void ensureBetween(String name, int min2, int max2, int value) throws IllegalArgumentException {
        if (value < min2 || value > max2) {
            throw new IllegalArgumentException(Errors.format((short)166, name, min2, max2, value));
        }
    }

    public static void ensureBetween(String name, long min2, long max2, long value) throws IllegalArgumentException {
        if (value < min2 || value > max2) {
            throw new IllegalArgumentException(Errors.format((short)166, name, min2, max2, value));
        }
    }

    public static void ensureBetween(String name, float min2, float max2, float value) throws IllegalArgumentException {
        if (!(value >= min2) || !(value <= max2)) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)166, name, Float.valueOf(min2), Float.valueOf(max2), Float.valueOf(value)));
        }
    }

    public static void ensureBetween(String name, double min2, double max2, double value) throws IllegalArgumentException {
        if (!(value >= min2) || !(value <= max2)) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)110, name) : Errors.format((short)166, name, min2, max2, value));
        }
    }

    @Deprecated(since="1.3", forRemoval=true)
    public static void ensureSizeBetween(String name, int min2, int max2, int size) throws IllegalArgumentException {
        ArgumentChecks.ensureCountBetween(name, true, min2, max2, size);
    }

    public static void ensureCountBetween(String name, boolean named, int min2, int max2, int count) throws IllegalArgumentException {
        String message;
        if (count < min2) {
            message = count == 0 ? Errors.format((short)29, name) : (named ? Errors.format((short)74, name, min2, count) : Errors.format((short)127, min2, count));
        } else if (count > max2) {
            message = named ? Errors.format((short)35, name, max2, count) : Errors.format((short)129, max2, count);
        } else {
            return;
        }
        throw new IllegalArgumentException(message);
    }

    public static void ensureValidUnicodeCodePoint(String name, int code) throws IllegalArgumentException {
        if (!Character.isValidCodePoint(code)) {
            throw new IllegalArgumentException(Errors.format((short)61, name, code < 0 ? Integer.valueOf(code) : "U+" + Integer.toHexString(code).toUpperCase()));
        }
    }

    public static void ensureDivisor(String name, int number, int divisor) {
        if (number % divisor != 0) {
            throw new IllegalArgumentException(Errors.format((short)193, name, 0, number, divisor));
        }
    }

    public static void ensureMultiple(String name, int number, int multiple) {
        if (multiple % number != 0) {
            throw new IllegalArgumentException(Errors.format((short)193, name, 1, number, multiple));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        int dimension;
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null && (dimension = cs.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, CoordinateSystem cs) throws MismatchedDimensionException {
        int dimension;
        if (cs != null && (dimension = cs.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, int[] indices) throws MismatchedDimensionException {
        int dimension;
        if (indices != null && (dimension = indices.length) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, double[] vector) throws MismatchedDimensionException {
        int dimension;
        if (vector != null && (dimension = vector.length) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, DirectPosition position) throws MismatchedDimensionException {
        int dimension;
        if (position != null && (dimension = position.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, Envelope envelope) throws MismatchedDimensionException {
        int dimension;
        if (envelope != null && (dimension = envelope.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, name, expected, dimension));
        }
    }

    public static void ensureDimensionsMatch(String name, int expectedSource, int expectedTarget, MathTransform transform) throws MismatchedDimensionException {
        if (transform != null) {
            int side = 0;
            int dimension = transform.getSourceDimensions();
            if (dimension == expectedSource) {
                dimension = transform.getTargetDimensions();
                if (dimension == expectedTarget) {
                    return;
                }
                expectedSource = expectedTarget;
                side = 1;
            }
            throw new MismatchedDimensionException(Errors.format((short)190, name, side, expectedSource, dimension));
        }
    }
}

