/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.uhighlight.LabelledCharArrayMatcher;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

final class MultiTermHighlighting {
    private MultiTermHighlighting() {
    }

    static LabelledCharArrayMatcher[] extractAutomata(Query query2, Predicate<String> fieldMatcher, boolean lookInSpan) {
        AutomataCollector collector = new AutomataCollector(lookInSpan, fieldMatcher);
        query2.visit(collector);
        return collector.runAutomata.toArray(new LabelledCharArrayMatcher[0]);
    }

    public static boolean canExtractAutomataFromLeafQuery(Query query2) {
        return query2 instanceof AutomatonQuery || query2 instanceof FuzzyQuery;
    }

    private static class AutomataCollector
    extends QueryVisitor {
        List<LabelledCharArrayMatcher> runAutomata = new ArrayList<LabelledCharArrayMatcher>();
        final boolean lookInSpan;
        final Predicate<String> fieldMatcher;

        private AutomataCollector(boolean lookInSpan, Predicate<String> fieldMatcher) {
            this.lookInSpan = lookInSpan;
            this.fieldMatcher = fieldMatcher;
        }

        @Override
        public boolean acceptField(String field) {
            return this.fieldMatcher.test(field);
        }

        @Override
        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (!this.lookInSpan && parent instanceof SpanQuery) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            return super.getSubVisitor(occur, parent);
        }

        @Override
        public void consumeTermsMatching(Query query2, String field, Supplier<ByteRunAutomaton> automaton) {
            this.runAutomata.add(LabelledCharArrayMatcher.wrap(query2.toString(), automaton.get()));
        }
    }
}

