/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryparser.surround.query.RewriteQuery;
import org.apache.lucene.queryparser.surround.query.SimpleTerm;
import org.apache.lucene.queryparser.surround.query.SrndBooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

class SimpleTermRewriteQuery
extends RewriteQuery<SimpleTerm> {
    SimpleTermRewriteQuery(SimpleTerm srndQuery, String fieldName, BasicQueryFactory qf) {
        super(srndQuery, fieldName, qf);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        final ArrayList<Query> luceneSubQueries = new ArrayList<Query>();
        ((SimpleTerm)this.srndQuery).visitMatchingTerms(indexSearcher.getIndexReader(), this.fieldName, new SimpleTerm.MatchingTermVisitor(){

            @Override
            public void visitMatchingTerm(Term term) throws IOException {
                luceneSubQueries.add(SimpleTermRewriteQuery.this.qf.newTermQuery(term));
            }
        });
        return luceneSubQueries.size() == 0 ? new MatchNoDocsQuery() : (luceneSubQueries.size() == 1 ? (Query)luceneSubQueries.get(0) : SrndBooleanQuery.makeBooleanQuery(luceneSubQueries, BooleanClause.Occur.SHOULD));
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

