/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.lib;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.record.Record;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.lib.ColumnMap;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;

public class TupleLib {
    public static Iterator<Tuple<Node>> convertToNodes(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodes(nodeTable, item));
    }

    public static Iterator<Tuple<NodeId>> convertToNodeId(NodeTable nodeTable, Iterator<Tuple<Node>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodeIds(nodeTable, item));
    }

    public static Iterator<Triple> convertToTriples(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.triple(nodeTable, item));
    }

    public static Iterator<Quad> convertToQuads(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.quad(nodeTable, item));
    }

    public static Tuple<Node> tupleNodes(NodeTable nodeTable, Tuple<NodeId> ids) {
        return ids.map(nid -> nodeTable.getNodeForNodeId((NodeId)nid));
    }

    public static Tuple<NodeId> tupleNodeIds(NodeTable nodeTable, Tuple<Node> nodes) {
        return nodes.map(n -> nodeTable.getNodeIdForNode((Node)n));
    }

    private static Triple triple(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 3) {
            throw new TDB1Exception("Tuple is not of length 3: " + String.valueOf(tuple));
        }
        return TupleLib.triple(nodeTable, tuple.get(0), tuple.get(1), tuple.get(2));
    }

    private static Triple triple(NodeTable nodeTable, NodeId s, NodeId p, NodeId o) {
        if (!NodeId.isConcrete(s)) {
            throw new InternalErrorException("Invalid id for subject: " + TupleLib.fmt(s, p, o));
        }
        if (!NodeId.isConcrete(p)) {
            throw new InternalErrorException("Invalid id for predicate: " + TupleLib.fmt(s, p, o));
        }
        if (!NodeId.isConcrete(o)) {
            throw new InternalErrorException("Invalid id for object: " + TupleLib.fmt(s, p, o));
        }
        Node sNode = nodeTable.getNodeForNodeId(s);
        if (sNode == null) {
            throw new InternalErrorException("Invalid id node for subject (null node): " + TupleLib.fmt(s, p, o));
        }
        Node pNode = nodeTable.getNodeForNodeId(p);
        if (pNode == null) {
            throw new InternalErrorException("Invalid id node for predicate (null node): " + TupleLib.fmt(s, p, o));
        }
        Node oNode = nodeTable.getNodeForNodeId(o);
        if (oNode == null) {
            throw new InternalErrorException("Invalid id node for object (null node): " + TupleLib.fmt(s, p, o));
        }
        return Triple.create(sNode, pNode, oNode);
    }

    private static String fmt(NodeId s, NodeId p, NodeId o) {
        return "(" + String.valueOf(s) + ", " + String.valueOf(p) + ", " + String.valueOf(o) + ")";
    }

    private static String fmt(NodeId g, NodeId s, NodeId p, NodeId o) {
        return "(" + String.valueOf(g) + "," + String.valueOf(s) + ", " + String.valueOf(p) + ", " + String.valueOf(o) + ")";
    }

    private static Quad quad(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 4) {
            throw new TDB1Exception("Tuple is not of length 4: " + String.valueOf(tuple));
        }
        return TupleLib.quad(nodeTable, tuple.get(0), tuple.get(1), tuple.get(2), tuple.get(3));
    }

    private static Quad quad(NodeTable nodeTable, NodeId g, NodeId s, NodeId p, NodeId o) {
        Node gNode = nodeTable.getNodeForNodeId(g);
        Node sNode = nodeTable.getNodeForNodeId(s);
        Node pNode = nodeTable.getNodeForNodeId(p);
        Node oNode = nodeTable.getNodeForNodeId(o);
        if (gNode == null) {
            throw new InternalErrorException("Invalid id node for graph (null node): " + TupleLib.fmt(g, s, p, o));
        }
        if (sNode == null) {
            throw new InternalErrorException("Invalid id node for subject (null node): " + TupleLib.fmt(g, s, p, o));
        }
        if (pNode == null) {
            throw new InternalErrorException("Invalid id node for predicate (null node): " + TupleLib.fmt(g, s, p, o));
        }
        if (oNode == null) {
            throw new InternalErrorException("Invalid id node for object (null node): " + TupleLib.fmt(g, s, p, o));
        }
        return Quad.create(gNode, sNode, pNode, oNode);
    }

    public static Tuple<NodeId> tuple(Record r, ColumnMap cMap) {
        int N = r.getKey().length / 8;
        NodeId[] nodeIds = new NodeId[N];
        for (int i = 0; i < N; ++i) {
            NodeId id = NodeId.create(r.getKey(), i * 8);
            int j = i;
            if (cMap != null) {
                j = cMap.fetchSlotIdx(i);
            }
            nodeIds[j] = id;
        }
        return TupleFactory.asTuple(nodeIds);
    }

    public static Record record(RecordFactory factory, Tuple<NodeId> tuple, ColumnMap cMap) {
        byte[] b = new byte[tuple.len() * 8];
        for (int i = 0; i < tuple.len(); ++i) {
            int j = cMap.mapSlotIdx(i);
            Bytes.setLong(tuple.get(i).getId(), b, j * 8);
        }
        return factory.create(b);
    }
}

