/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.graph.GraphSink;
import org.apache.jena.sparql.graph.GraphTxn;
import org.apache.jena.sys.JenaSystem;

public class GraphFactory {
    private static boolean defaultSameTerm;

    @Deprecated
    public static void setDftGraphSameTerm(boolean value) {
        defaultSameTerm = value;
    }

    public static Graph createGraphMem() {
        return GraphMemFactory.createDefaultGraphSameTerm();
    }

    public static GraphTxn createTxnGraph() {
        return new GraphTxn();
    }

    public static Graph createDefaultGraph() {
        return GraphFactory.createJenaDefaultGraph();
    }

    public static Graph createJenaDefaultGraph() {
        return GraphMemFactory.createDefaultGraph();
    }

    @Deprecated
    public static Graph createPlainGraph() {
        return GraphPlain.plain();
    }

    public static Graph sinkGraph() {
        return new GraphSink();
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createDefaultGraph());
    }

    public static Model makePlainModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createPlainGraph());
    }

    static {
        JenaSystem.init();
        defaultSameTerm = true;
        String x = System.getProperty("jena:graphSameTerm");
        if (x != null && x.equalsIgnoreCase("true")) {
            defaultSameTerm = true;
        }
    }
}

