/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExecAdapter;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;

public interface QueryExec
extends AutoCloseable {
    public static QueryExecBuilder dataset(DatasetGraph dataset) {
        return QueryExecDatasetBuilder.create().dataset(dataset);
    }

    public static QueryExecBuilder graph(Graph graph) {
        return QueryExecDatasetBuilder.create().graph(graph);
    }

    public static QueryExecBuilder service(String serviceURL) {
        return (QueryExecBuilder)QueryExecHTTPBuilder.create().endpoint(serviceURL);
    }

    public static QueryExecDatasetBuilder newBuilder() {
        return QueryExecDatasetBuilder.create();
    }

    public DatasetGraph getDataset();

    public Context getContext();

    public Query getQuery();

    public String getQueryString();

    public RowSet select();

    default public Graph construct() {
        Graph graph = GraphFactory.createDefaultGraph();
        return this.construct(graph);
    }

    public Graph construct(Graph var1);

    public Iterator<Triple> constructTriples();

    public Iterator<Quad> constructQuads();

    default public DatasetGraph constructDataset() {
        return this.constructDataset(DatasetGraphFactory.create());
    }

    public DatasetGraph constructDataset(DatasetGraph var1);

    default public Graph describe() {
        Graph graph = GraphFactory.createDefaultGraph();
        return this.describe(graph);
    }

    public Graph describe(Graph var1);

    public Iterator<Triple> describeTriples();

    public boolean ask();

    public JsonArray execJson();

    public Iterator<JsonObject> execJsonItems();

    public void abort();

    @Override
    public void close();

    public boolean isClosed();

    public static QueryExec adapt(QueryExecution qExec) {
        return QueryExecAdapter.adapt(qExec);
    }
}

