/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;

public class QueryIteratorMapped
extends QueryIteratorWrapper {
    private Map<Var, Var> varMapping;

    public QueryIteratorMapped(QueryIterator qIter, Map<Var, Var> varMapping) {
        super(qIter);
        this.varMapping = varMapping;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding b = super.moveToNextBinding();
        if (this.varMapping == null) {
            return b;
        }
        BindingBuilder builder = Binding.builder();
        Iterator<Var> vs = b.vars();
        while (vs.hasNext()) {
            Var v = vs.next();
            Node value = b.get(v);
            if (value == null || !this.varMapping.containsKey(v)) continue;
            builder.add(this.varMapping.get(v), value);
        }
        return builder.build();
    }
}

