/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.cache.CacheCaffeine;

public class CacheConfiguration {
    public static final int UNLIMITED_MAP = -1;
    public static final int NO_MAP = 0;
    public static final long MAP_EXPIRY_INTERVAL = 5000L;
    public static final int UNLIMITED_INITIAL_CAPACITY = 50000;

    private CacheConfiguration() {
    }

    public static <K, V> Cache<K, V> create(long maxSize, long expiryMilliseconds) {
        if (maxSize == 0L) {
            return CacheFactory.createNullCache();
        }
        long actualMaxSize = maxSize > -1L ? maxSize : Long.MAX_VALUE;
        int actualInitialCapacity = actualMaxSize == Long.MAX_VALUE ? 50000 : (int)actualMaxSize / 4;
        return new CacheCaffeine(expiryMilliseconds > 0L ? Caffeine.newBuilder().maximumSize(actualMaxSize).initialCapacity(actualInitialCapacity).expireAfterAccess(Duration.ofMillis(expiryMilliseconds)).build() : Caffeine.newBuilder().maximumSize(actualMaxSize).initialCapacity(actualInitialCapacity).build());
    }
}

