/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.net.BindException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.FusekiMain;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.FusekiServerArgsCustomiser;
import org.apache.jena.fuseki.mod.FusekiServerModules;

public class FusekiServerRunner {
    public static FusekiServer runAsync(String ... args) {
        FusekiServer server = FusekiServerRunner.construct(args);
        try {
            return server.start();
        }
        catch (FusekiException ex) {
            if (ex.getCause() instanceof BindException) {
                Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port in use");
                System.exit(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
    }

    public static void run(String ... args) {
        FusekiServer server = FusekiServerRunner.runAsync(args);
        server.join();
    }

    public static FusekiServer construct(String ... args) {
        FusekiServer.Builder builder = FusekiServerRunner.builder(args);
        return builder.build();
    }

    public static FusekiServer.Builder builder(String ... args) {
        FusekiServerRunner.prepareFusekiServerConstruct();
        try {
            FusekiServer.Builder builder = FusekiMain.builder(args);
            return builder;
        }
        finally {
            FusekiServerRunner.resetFusekiMain();
        }
    }

    private static void prepareFusekiServerConstruct() {
        String fusekiBase = Lib.getenv("FUSEKI_BASE");
        if (fusekiBase == null) {
            fusekiBase = "run";
        }
        FileOps.ensureDir(fusekiBase);
        final FusekiModules serverModules = FusekiServerModules.serverModules();
        FusekiServerArgsCustomiser initializeServerArgs = new FusekiServerArgsCustomiser(){

            @Override
            public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
                serverArgs.allowEmpty = true;
                serverArgs.fusekiModules = serverModules;
            }
        };
        FusekiMain.resetCustomisers();
        FusekiMain.addCustomiser(initializeServerArgs);
        serverModules.forEach(FusekiMain::addCustomiser);
    }

    private static void resetFusekiMain() {
        FusekiMain.resetCustomisers();
    }
}

