/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.SysTransState;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;

public class TransMonitor
implements TransactionalComponent {
    private Map<String, LongAdder> counters = new LinkedHashMap<String, LongAdder>();
    private final ComponentId componentId;
    public LongAdder counterGetComponentId = this.allocCounter("getComponentId");
    public LongAdder counterStartRecovery = this.allocCounter("startRecovery");
    public LongAdder counterRecover = this.allocCounter("recover");
    public LongAdder counterFinishRecovery = this.allocCounter("finishRecovery");
    public LongAdder counterCleanStart = this.allocCounter("finishRecovery");
    public LongAdder counterBegin = this.allocCounter("begin");
    public LongAdder counterPromote = this.allocCounter("promote");
    public LongAdder counterCommitPrepare = this.allocCounter("commitPrepare");
    public LongAdder counterCommit = this.allocCounter("commit");
    public LongAdder counterCommitEnd = this.allocCounter("commitEnd");
    public LongAdder counterAbort = this.allocCounter("abort");
    public LongAdder counterComplete = this.allocCounter("complete");
    public LongAdder counterDetach = this.allocCounter("detach");
    public LongAdder counterAttach = this.allocCounter("attach");
    public LongAdder counterShutdown = this.allocCounter("shutdown");

    private LongAdder allocCounter(String string) {
        LongAdder counter = new LongAdder();
        this.counters.put(string, counter);
        return counter;
    }

    public TransMonitor(ComponentId cid) {
        this.componentId = cid;
    }

    public void reset() {
        this.counters.forEach((s, c) -> c.reset());
    }

    public Map<String, Long> getAll() {
        return this.counters.entrySet().stream().collect(Collectors.toMap(e2 -> (String)e2.getKey(), e2 -> ((LongAdder)e2.getValue()).sum()));
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream ps) {
        ps.println("Transaction Counters:");
        this.counters.forEach((s, c) -> ps.printf("   %-15s %4d\n", s, c.longValue()));
    }

    @Override
    public ComponentId getComponentId() {
        this.counterGetComponentId.increment();
        return this.componentId;
    }

    @Override
    public void startRecovery() {
        this.counterStartRecovery.increment();
    }

    @Override
    public void recover(ByteBuffer ref) {
        this.counterRecover.increment();
    }

    @Override
    public void finishRecovery() {
        this.counterFinishRecovery.increment();
    }

    @Override
    public void cleanStart() {
        this.counterCleanStart.increment();
    }

    @Override
    public void begin(Transaction transaction) {
        this.counterBegin.increment();
    }

    @Override
    public boolean promote(Transaction transaction) {
        this.counterPromote.increment();
        return true;
    }

    @Override
    public ByteBuffer commitPrepare(Transaction transaction) {
        this.counterCommitPrepare.increment();
        return null;
    }

    @Override
    public void commit(Transaction transaction) {
        this.counterCommit.increment();
    }

    @Override
    public void commitEnd(Transaction transaction) {
        this.counterCommitEnd.increment();
    }

    @Override
    public void abort(Transaction transaction) {
        this.counterAbort.increment();
    }

    @Override
    public void complete(Transaction transaction) {
        this.counterComplete.increment();
    }

    @Override
    public SysTransState detach() {
        this.counterDetach.increment();
        return null;
    }

    @Override
    public void attach(SysTransState systemState) {
        this.counterAttach.increment();
    }

    @Override
    public void shutdown() {
        this.counterShutdown.increment();
    }
}

