/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.sparql.core.Quad;

public class PrintingStreamRDF
extends WriterStreamRDFPlain {
    private PrefixMap prefixMap = PrefixMapFactory.create();
    private NodeFormatter pretty = new NodeFormatterTTL(null, this.prefixMap);

    public PrintingStreamRDF(OutputStream out) {
        super(IO.wrapUTF8((OutputStream)out));
    }

    public PrintingStreamRDF(AWriter out) {
        super(out);
    }

    @Override
    protected NodeFormatter getFmt() {
        return this.pretty;
    }

    private static void printDirectURI(AWriter out, String iriStr) {
        out.print("<");
        out.print(iriStr);
        out.print(">");
    }

    @Override
    public void base(String base) {
        this.out.print("BASE");
        this.out.print("  ");
        PrintingStreamRDF.printDirectURI(this.out, base);
        this.out.println();
        this.flush();
        this.pretty = new NodeFormatterTTL(base, this.prefixMap);
    }

    @Override
    public void prefix(String prefix, String iri) {
        this.out.print("PREFIX");
        this.out.print("  ");
        this.out.print(prefix);
        this.out.print(":  ");
        PrintingStreamRDF.printDirectURI(this.out, iri);
        this.out.println();
        this.prefixMap.add(prefix, iri);
        this.flush();
    }

    @Override
    public void triple(Triple triple) {
        super.triple(triple);
        this.flush();
    }

    @Override
    public void quad(Quad quad) {
        super.quad(quad);
        this.flush();
    }

    public void flush() {
        IO.flush((AWriter)this.out);
    }
}

