/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class InverseContextBuilder {
    private final ActiveContext activeContext;

    private InverseContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static final InverseContextBuilder with(ActiveContext activeContext) {
        return new InverseContextBuilder(activeContext);
    }

    public InverseContext build() {
        InverseContext result = new InverseContext();
        String defaultLanguage = this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage().toLowerCase() : "@none";
        this.activeContext.getTerms().stream().filter(termName -> this.activeContext.getTerm((String)termName).map(TermDefinition::getUriMapping).isPresent()).sorted().forEach(termName -> this.processTerm((String)termName, result, this.activeContext.getTerm((String)termName).map(TermDefinition::getUriMapping).get(), defaultLanguage));
        return result;
    }

    private void processTerm(String termName, InverseContext result, String variableValue, String defaultLanguage) {
        String container = this.activeContext.getTerm(termName).map(TermDefinition::getContainerMapping).filter(collection -> !collection.isEmpty()).orElseGet(() -> Arrays.asList("@none")).stream().sorted().collect(Collectors.joining());
        result.setIfAbsent(variableValue, container, "@any", "@none", termName);
        if (this.activeContext.getTerm(termName).filter(TermDefinition::isReverseProperty).isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", "@reverse", termName);
            return;
        }
        Optional<String> typeMapping = this.activeContext.getTerm(termName).map(TermDefinition::getTypeMapping);
        if (typeMapping.filter("@none"::equals).isPresent()) {
            result.setIfAbsent(variableValue, container, "@language", "@any", termName).setIfAbsent(variableValue, container, "@type", "@any", termName);
            return;
        }
        if (typeMapping.isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", typeMapping.get(), termName);
            return;
        }
        Optional<JsonValue> languageMapping = this.activeContext.getTerm(termName).map(TermDefinition::getLanguageMapping);
        Optional<DirectionType> directionMapping = this.activeContext.getTerm(termName).map(TermDefinition::getDirectionMapping);
        if (languageMapping.isPresent()) {
            String langDir;
            JsonValue language = languageMapping.get();
            if (directionMapping.isPresent()) {
                DirectionType direction = directionMapping.get();
                langDir = JsonUtils.isString(language) ? (direction != DirectionType.NULL ? ((JsonString)language).getString().concat("_").concat(direction.name()).toLowerCase() : ((JsonString)language).getString().toLowerCase()) : (direction != DirectionType.NULL ? "_".concat(direction.name().toLowerCase()) : "@null");
            } else {
                langDir = JsonUtils.isString(language) ? ((JsonString)language).getString().toLowerCase() : "@null";
            }
            result.setIfAbsent(variableValue, container, "@language", langDir, termName);
        } else if (directionMapping.isPresent()) {
            String direction = directionMapping.filter(d -> d != DirectionType.NULL).map(d -> "_".concat(d.name().toLowerCase())).orElse("@none");
            result.setIfAbsent(variableValue, container, "@language", direction, termName);
        } else {
            String langDir = this.activeContext.getDefaultBaseDirection() != null ? (this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage() : "").concat("_").concat(this.activeContext.getDefaultBaseDirection().name()).toLowerCase() : defaultLanguage;
            result.setIfAbsent(variableValue, container, "@language", langDir, termName).setIfAbsent(variableValue, container, "@language", "@none", termName).setIfAbsent(variableValue, container, "@type", "@none", termName);
        }
    }
}

