/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.writer;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.compact.ShaclcWriter;
import org.apache.jena.sparql.util.Context;

public class WriterRIOTShaclc
extends WriterGraphRIOTBase {
    public Lang getLang() {
        return Lang.SHACLC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        IndentedWriter iOut = RiotLib.create((Writer)out);
        try {
            iOut.setAbsoluteIndent(4);
            this.write(iOut, graph, prefixMap, baseURI, context);
        }
        finally {
            iOut.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        IndentedWriter iOut = new IndentedWriter(out);
        try {
            iOut.setUnitIndent(4);
            this.write(iOut, graph, prefixMap, baseURI, context);
        }
        finally {
            iOut.flush();
        }
    }

    private void write(IndentedWriter out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        Shapes shapes = Shapes.parse(graph);
        ShaclcWriter.print(out, shapes);
    }
}

