/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.recordbuffer;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.page.PageBase;
import org.apache.jena.dboe.base.record.RecordFactory;

public abstract class RecordBufferPageBase
extends PageBase {
    public static final int COUNT = 0;
    private static final int FIELD_LENGTH = 4;
    protected final int headerLength;
    protected RecordBuffer recBuff;
    private final RecordFactory factory;

    public static int calcRecordSize(RecordFactory factory, int blkSize, int headerOffset) {
        int x = blkSize - RecordBufferPageBase.totalOffset(headerOffset);
        return x / factory.recordLength();
    }

    public static int calcBlockSize(RecordFactory factory, int maxRec, int headerOffset) {
        return RecordBufferPageBase.totalOffset(headerOffset) + factory.recordLength() * maxRec;
    }

    private static int totalOffset(int headerOffset) {
        return 4 + headerOffset;
    }

    protected RecordBufferPageBase(Block block, int offset, RecordFactory factory, int count) {
        super(block);
        this.headerLength = 4 + offset;
        this.factory = factory;
        this.rebuild(block, count);
    }

    protected void rebuild(Block block, int count) {
        ByteBuffer bb = block.getByteBuffer();
        bb.clear();
        bb.position(this.headerLength);
        bb = bb.slice();
        this.recBuff = new RecordBuffer(bb, this.factory, count);
    }

    public final RecordBuffer getRecordBuffer() {
        return this.recBuff;
    }

    public final int getCount() {
        return this.recBuff.size();
    }

    public final int getMaxSize() {
        return this.recBuff.maxSize();
    }

    public void setCount(int count) {
        this.recBuff.setSize(count);
    }

    public String toString() {
        return String.format("RecordBufferPageBase[id=%d]: %s", this.getBackingBlock().getId(), this.recBuff);
    }

    public void output(IndentedWriter out) {
        out.print(this.toString());
    }
}

