/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.page;

import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.page.Page;

public abstract class PageBase
implements Page {
    private int id;
    private Block block;

    protected PageBase(Block block) {
        this.block = block;
        long x = block.getId();
        if (x < 0L) {
            throw new DBOpEnvException("Page id is negative: " + x);
        }
        if (x > Integer.MAX_VALUE) {
            throw new DBOpEnvException("Page id is large than MAX_INT: " + x);
        }
        this.id = block.getId().intValue();
    }

    @Override
    public final void reset(Block block2) {
        this.id = block2.getId().intValue();
        this._reset(block2);
        this.block = block2;
    }

    protected abstract void _reset(Block var1);

    @Override
    public final Block getBackingBlock() {
        return this.block;
    }

    @Override
    public final int getId() {
        return this.id;
    }
}

