/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.net.http.HttpClient;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.rdflink.RDFLinkHTTPBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.exec.http.UpdateSendMode;

public class RDFLinkFuseki
extends RDFLinkHTTP {
    public static RDFLinkHTTPBuilder newBuilder() {
        return RDFLinkFuseki.setupForFuseki(RDFLinkHTTP.newBuilder());
    }

    public static RDFLinkHTTPBuilder from(RDFLinkFuseki other) {
        return RDFLinkFuseki.setupCreator(RDFLinkHTTP.from(other));
    }

    private static RDFLinkHTTPBuilder setupForFuseki(RDFLinkHTTPBuilder builder) {
        String ctRDFThrift = Lang.RDFTHRIFT.getHeaderString();
        String acceptHeaderSPARQL = String.join((CharSequence)",", ResultSetLang.RS_Thrift.getHeaderString(), ResultSetLang.RS_JSON.getHeaderString() + ";q=0.9", Lang.RDFTHRIFT.getHeaderString());
        return builder.quadsFormat(RDFFormat.RDF_THRIFT).triplesFormat(RDFFormat.RDF_THRIFT).acceptHeaderGraph(ctRDFThrift).acceptHeaderDataset(ctRDFThrift).acceptHeaderSelectQuery(ResultSetLang.RS_Thrift.getHeaderString()).acceptHeaderAskQuery(ResultSetLang.RS_JSON.getHeaderString()).acceptHeaderQuery(acceptHeaderSPARQL).parseCheckSPARQL(false).creator(b -> RDFLinkFuseki.fusekiMaker(b));
    }

    private static RDFLinkHTTPBuilder setupCreator(RDFLinkHTTPBuilder builder) {
        return builder.creator(b -> RDFLinkFuseki.fusekiMaker(b));
    }

    static RDFLinkFuseki fusekiMaker(RDFLinkHTTPBuilder builder) {
        return new RDFLinkFuseki(builder);
    }

    protected RDFLinkFuseki(RDFLinkHTTPBuilder base) {
        this(base.txnLifecycle, base.httpClient, base.destination, base.queryURL, base.updateURL, base.gspURL, base.outputQuads, base.outputTriples, base.acceptDataset, base.acceptGraph, base.acceptSparqlResults, base.acceptSelectResult, base.acceptAskResult, base.parseCheckQueries, base.parseCheckUpdates, base.querySendMode, base.updateSendMode);
    }

    protected RDFLinkFuseki(Transactional txnLifecycle, HttpClient httpClient, String destination, String queryURL, String updateURL, String gspURL, RDFFormat outputQuads, RDFFormat outputTriples, String acceptDataset, String acceptGraph, String acceptSparqlResults, String acceptSelectResult, String acceptAskResult, boolean parseCheckQueries, boolean parseCheckUpdates, QuerySendMode querySendMode, UpdateSendMode updateSendMode) {
        super(txnLifecycle, httpClient, destination, queryURL, updateURL, gspURL, outputQuads, outputTriples, acceptDataset, acceptGraph, acceptSparqlResults, acceptSelectResult, acceptAskResult, parseCheckQueries, parseCheckUpdates, querySendMode, updateSendMode);
    }
}

