/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractPemKeyStore;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractMutablePemKeyStore
extends AbstractPemKeyStore {
    @Override
    protected Map<String, AbstractPemKeyStore.Entry> initializeEmpty() {
        return new HashMap<String, AbstractPemKeyStore.Entry>();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(key);
        AbstractPemKeyStore.Entry entry = new AbstractPemKeyStore.Entry(key, (Certificate[])chain.clone());
        this.entries.put(alias, entry);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Unsupported operation");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(cert);
        AbstractPemKeyStore.Entry entry = new AbstractPemKeyStore.Entry(null, new Certificate[]{cert});
        this.entries.put(alias, entry);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.entries.remove(alias);
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("Unsupported operation");
    }
}

