/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.SocketConfigurator;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public abstract class SocketConfigurators {
    public static final SocketConfigurator DISABLE_NAGLE_ALGORITHM;
    public static final SocketConfigurator DEFAULT;
    public static final SocketConfigurator ENABLE_HOSTNAME_VERIFICATION;

    static final SSLParameters enableHostnameVerification(SSLParameters sslParameters) {
        if (sslParameters == null) {
            sslParameters = new SSLParameters();
        }
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    public static SocketConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static SocketConfigurator disableNagleAlgorithm() {
        return DISABLE_NAGLE_ALGORITHM;
    }

    public static SocketConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT = DISABLE_NAGLE_ALGORITHM = socket -> socket.setTcpNoDelay(true);
        ENABLE_HOSTNAME_VERIFICATION = socket -> {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                SSLParameters sslParameters = SocketConfigurators.enableHostnameVerification(sslSocket.getSSLParameters());
                sslSocket.setSSLParameters(sslParameters);
            }
        };
    }

    public static class Builder {
        private SocketConfigurator configurator = socket -> {};

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder disableNagleAlgorithm() {
            this.configurator = this.configurator.andThen(DISABLE_NAGLE_ALGORITHM);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SocketConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SocketConfigurator build() {
            return this.configurator;
        }
    }
}

