/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTaskRunner;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class MailboxMergingTask
implements Task {
    public static final TaskType MAILBOX_MERGING = TaskType.of((String)"mailbox-merging");
    private final MailboxMergingTaskRunner taskRunner;
    private final CassandraId oldMailboxId;
    private final CassandraId newMailboxId;
    private final Context context;

    public MailboxMergingTask(MailboxMergingTaskRunner taskRunner, long totalMessagesToMove, CassandraId oldMailboxId, CassandraId newMailboxId) {
        this.taskRunner = taskRunner;
        this.oldMailboxId = oldMailboxId;
        this.newMailboxId = newMailboxId;
        this.context = new Context(totalMessagesToMove);
    }

    public Task.Result run() {
        return this.taskRunner.run(this.oldMailboxId, this.newMailboxId, this.context);
    }

    public TaskType type() {
        return MAILBOX_MERGING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new Details(this.oldMailboxId, this.newMailboxId, this.context.getTotalMessageCount(), this.context.getMessageMovedCount(), this.context.getMessageFailedCount(), Clock.systemUTC().instant()));
    }

    Context getContext() {
        return this.context;
    }

    CassandraId getNewMailboxId() {
        return this.newMailboxId;
    }

    CassandraId getOldMailboxId() {
        return this.oldMailboxId;
    }

    public static class Context {
        private final long totalMessageCount;
        private final AtomicLong totalMessageMoved;
        private final AtomicLong totalMessageFailed;

        public Context(long totalMessagesCount) {
            this.totalMessageCount = totalMessagesCount;
            this.totalMessageMoved = new AtomicLong(0L);
            this.totalMessageFailed = new AtomicLong(0L);
        }

        public long getTotalMessageCount() {
            return this.totalMessageCount;
        }

        public long getMessageMovedCount() {
            return this.totalMessageMoved.get();
        }

        public long getMessageFailedCount() {
            return this.totalMessageFailed.get();
        }

        public void incrementMovedCount() {
            this.totalMessageMoved.incrementAndGet();
        }

        public void incrementFailedCount() {
            this.totalMessageFailed.incrementAndGet();
        }
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final CassandraId oldMailboxId;
        private final CassandraId newMailboxId;
        private final long totalMessageCount;
        private final long messageMovedCount;
        private final long messageFailedCount;
        private final Instant timestamp;

        public Details(CassandraId oldId, CassandraId newId, long totalMessageCount, long messageMovedCount, long messageFailedCount, Instant timestamp) {
            this.oldMailboxId = oldId;
            this.newMailboxId = newId;
            this.totalMessageCount = totalMessageCount;
            this.messageMovedCount = messageMovedCount;
            this.messageFailedCount = messageFailedCount;
            this.timestamp = timestamp;
        }

        public String getOldMailboxId() {
            return this.oldMailboxId.serialize();
        }

        public String getNewMailboxId() {
            return this.newMailboxId.serialize();
        }

        public long getTotalMessageCount() {
            return this.totalMessageCount;
        }

        public long getMessageMovedCount() {
            return this.messageMovedCount;
        }

        public long getMessageFailedCount() {
            return this.messageFailedCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

