/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.data.jmap.RecomputeUserFastViewProjectionItemsTask;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.apache.james.webadmin.data.jmap.RunningOptionsDTO;

public class RecomputeUserFastViewTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final Instant timestamp;
    private final String username;
    private final long processedMessageCount;
    private final long failedMessageCount;
    private final Optional<RunningOptionsDTO> runningOptions;

    public static AdditionalInformationDTOModule<RecomputeUserFastViewProjectionItemsTask.AdditionalInformation, RecomputeUserFastViewTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(RecomputeUserFastViewProjectionItemsTask.AdditionalInformation.class).convertToDTO(RecomputeUserFastViewTaskAdditionalInformationDTO.class).toDomainObjectConverter(RecomputeUserFastViewTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(RecomputeUserFastViewTaskAdditionalInformationDTO::toDTO).typeName(RecomputeUserFastViewProjectionItemsTask.TASK_TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private static RecomputeUserFastViewTaskAdditionalInformationDTO toDTO(RecomputeUserFastViewProjectionItemsTask.AdditionalInformation details, String type) {
        return new RecomputeUserFastViewTaskAdditionalInformationDTO(type, details.timestamp(), details.getUsername(), details.getProcessedMessageCount(), details.getFailedMessageCount(), Optional.of(RunningOptionsDTO.asDTO(details.getRunningOptions())));
    }

    private static RecomputeUserFastViewProjectionItemsTask.AdditionalInformation toDomainObject(RecomputeUserFastViewTaskAdditionalInformationDTO dto) {
        return new RecomputeUserFastViewProjectionItemsTask.AdditionalInformation(dto.getRunningOptions().map(RunningOptionsDTO::asDomainObject).orElse(RunningOptions.DEFAULT), Username.of((String)dto.username), dto.getProcessedMessageCount(), dto.getFailedMessageCount(), dto.timestamp);
    }

    private RecomputeUserFastViewTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="username") String username, @JsonProperty(value="processedMessageCount") long processedMessageCount, @JsonProperty(value="failedMessageCount") long failedMessageCount, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptionsDTO) {
        this.type = type;
        this.timestamp = timestamp;
        this.username = username;
        this.processedMessageCount = processedMessageCount;
        this.failedMessageCount = failedMessageCount;
        this.runningOptions = runningOptionsDTO;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getProcessedMessageCount() {
        return this.processedMessageCount;
    }

    public long getFailedMessageCount() {
        return this.failedMessageCount;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    public String getUsername() {
        return this.username;
    }
}

