/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.term;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class TypeHintTerm
implements Term {
    private final Term term;
    private final DataType targetType;

    public TypeHintTerm(@NonNull Term term, @NonNull DataType targetType) {
        this.term = term;
        this.targetType = targetType;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append('(').append(this.targetType.asCql(false, true)).append(')');
        this.term.appendTo(builder);
    }

    @Override
    public boolean isIdempotent() {
        return this.term.isIdempotent();
    }

    @NonNull
    public Term getTerm() {
        return this.term;
    }

    @NonNull
    public DataType getTargetType() {
        return this.targetType;
    }
}

