/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import jakarta.mail.Flags;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageFetchStrategy;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.postgres.extensions.types.Hstore;

interface PostgresMailboxMessageDAOUtils {
    public static final Map<Field<Boolean>, Flags.Flag> BOOLEAN_FLAGS_MAPPING = Map.of(PostgresMessageDataDefinition.MessageToMailboxTable.IS_ANSWERED, Flags.Flag.ANSWERED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED, Flags.Flag.DELETED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DRAFT, Flags.Flag.DRAFT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_FLAGGED, Flags.Flag.FLAGGED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT, Flags.Flag.RECENT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN, Flags.Flag.SEEN);
    public static final Function<Record, MessageUid> RECORD_TO_MESSAGE_UID_FUNCTION = record -> MessageUid.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID)));
    public static final Function<Record, Flags> RECORD_TO_FLAGS_FUNCTION = record -> {
        Flags flags = new Flags();
        BOOLEAN_FLAGS_MAPPING.forEach((flagColumn, flagMapped) -> {
            if (((Boolean)record.get(flagColumn)).booleanValue()) {
                flags.add(flagMapped);
            }
        });
        Optional.ofNullable((String[])record.get(PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS)).stream().flatMap(Arrays::stream).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return flags;
    };
    public static final Function<Record, ThreadId> RECORD_TO_THREAD_ID_FUNCTION = record -> Optional.ofNullable((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.THREAD_ID)).map(threadIdAsUuid -> ThreadId.fromBaseMessageId((MessageId)PostgresMessageId.Factory.of(threadIdAsUuid))).orElse(ThreadId.fromBaseMessageId((MessageId)PostgresMessageId.Factory.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID))));
    public static final Field<?>[] MESSAGE_METADATA_FIELDS_REQUIRE = new Field[]{PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID, PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, PostgresMessageDataDefinition.MessageTable.SIZE, PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, PostgresMessageDataDefinition.MessageToMailboxTable.SAVE_DATE, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID, PostgresMessageDataDefinition.MessageToMailboxTable.THREAD_ID, PostgresMessageDataDefinition.MessageToMailboxTable.IS_ANSWERED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DRAFT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_FLAGGED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN, PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS};
    public static final Function<Record, MessageMetaData> RECORD_TO_MESSAGE_METADATA_FUNCTION = record -> new MessageMetaData(MessageUid.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID))), ModSeq.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ))), RECORD_TO_FLAGS_FUNCTION.apply((Record)record), ((Long)record.get(PostgresMessageDataDefinition.MessageTable.SIZE)).longValue(), (Date)PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION.apply((LocalDateTime)record.get(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE)), Optional.ofNullable((LocalDateTime)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.SAVE_DATE)).map(PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION), (MessageId)PostgresMessageId.Factory.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID)), RECORD_TO_THREAD_ID_FUNCTION.apply((Record)record));
    public static final Function<Record, ComposedMessageIdWithMetaData> RECORD_TO_COMPOSED_MESSAGE_ID_WITH_META_DATA_FUNCTION = record -> ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)PostgresMailboxId.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID)), (MessageId)PostgresMessageId.Factory.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_ID)), MessageUid.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID))))).threadId(RECORD_TO_THREAD_ID_FUNCTION.apply((Record)record)).flags(RECORD_TO_FLAGS_FUNCTION.apply((Record)record)).modSeq(ModSeq.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ)))).build();
    public static final Function<Record, Properties> RECORD_TO_PROPERTIES_FUNCTION = record -> {
        PropertyBuilder property = new PropertyBuilder();
        property.setMediaType((String)record.get(PostgresMessageDataDefinition.MessageTable.MIME_TYPE));
        property.setSubType((String)record.get(PostgresMessageDataDefinition.MessageTable.MIME_SUBTYPE));
        property.setTextualLineCount((Long)Optional.ofNullable((Integer)record.get(PostgresMessageDataDefinition.MessageTable.TEXTUAL_LINE_COUNT)).map(Long::valueOf).orElse(null));
        property.setContentDescription((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_DESCRIPTION));
        property.setContentDispositionType((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_TYPE));
        property.setContentID((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_ID));
        property.setContentMD5((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_MD5));
        property.setContentTransferEncoding((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_TRANSFER_ENCODING));
        property.setContentLocation((String)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_LOCATION));
        property.setContentLanguage((List)Optional.ofNullable((String[])record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_LANGUAGE)).map(List::of).orElse(null));
        property.setContentDispositionParameters(((Hstore)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_PARAMETERS)).data());
        property.setContentTypeParameters(((Hstore)record.get(PostgresMessageDataDefinition.MessageTable.CONTENT_TYPE_PARAMETERS)).data());
        return property.build();
    };
    public static final Function<byte[], Content> BYTE_TO_CONTENT_FUNCTION = contentAsBytes -> new Content((byte[])contentAsBytes){
        final /* synthetic */ byte[] val$contentAsBytes;
        {
            this.val$contentAsBytes = byArray;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.val$contentAsBytes);
        }

        public long size() {
            return this.val$contentAsBytes.length;
        }
    };
    public static final Function<MessageMapper.FetchType, PostgresMailboxMessageFetchStrategy> FETCH_TYPE_TO_FETCH_STRATEGY = fetchType -> {
        switch (fetchType) {
            case METADATA: 
            case ATTACHMENTS_METADATA: {
                return PostgresMailboxMessageFetchStrategy.METADATA;
            }
            case HEADERS: 
            case FULL: {
                return PostgresMailboxMessageFetchStrategy.FULL;
            }
        }
        throw new RuntimeException("Unknown FetchType " + String.valueOf(fetchType));
    };
}

