/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ParsedAttachment;
import org.apache.james.mailbox.postgres.mail.dao.PostgresAttachmentDAO;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresAttachmentMapper
implements AttachmentMapper {
    private final PostgresAttachmentDAO postgresAttachmentDAO;
    private final BlobStore blobStore;
    private final AttachmentIdAssignationStrategy attachmentIdAssignationStrategy;

    public PostgresAttachmentMapper(PostgresAttachmentDAO postgresAttachmentDAO, BlobStore blobStore, AttachmentIdAssignationStrategy attachmentIdAssignationStrategy) {
        this.postgresAttachmentDAO = postgresAttachmentDAO;
        this.blobStore = blobStore;
        this.attachmentIdAssignationStrategy = attachmentIdAssignationStrategy;
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId) {
        return (InputStream)this.loadAttachmentContentReactive(attachmentId).block();
    }

    public Mono<InputStream> loadAttachmentContentReactive(AttachmentId attachmentId) {
        return this.postgresAttachmentDAO.getAttachment(attachmentId).flatMap(pair -> Mono.from((Publisher)this.blobStore.readReactive(this.blobStore.getDefaultBucketName(), (BlobId)pair.getRight(), BlobStore.StoragePolicy.LOW_COST))).switchIfEmpty(Mono.error(() -> new AttachmentNotFoundException(attachmentId.toString())));
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId) throws AttachmentNotFoundException {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return (AttachmentMetadata)this.postgresAttachmentDAO.getAttachment(attachmentId).map(Pair::getLeft).blockOptional().orElseThrow(() -> new AttachmentNotFoundException(attachmentId.getId()));
    }

    public Mono<AttachmentMetadata> getAttachmentReactive(AttachmentId attachmentId) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.postgresAttachmentDAO.getAttachment(attachmentId).map(Pair::getLeft).switchIfEmpty(Mono.error(() -> new AttachmentNotFoundException(attachmentId.getId())));
    }

    public Flux<AttachmentMetadata> getAttachmentsReactive(Collection<AttachmentId> attachmentIds) {
        Preconditions.checkArgument((attachmentIds != null ? 1 : 0) != 0);
        return this.postgresAttachmentDAO.getAttachments(attachmentIds);
    }

    public List<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        return (List)this.getAttachmentsReactive(attachmentIds).collectList().block();
    }

    public List<MessageAttachmentMetadata> storeAttachments(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) {
        return (List)this.storeAttachmentsReactive(attachments, ownerMessageId).block();
    }

    public Mono<List<MessageAttachmentMetadata>> storeAttachmentsReactive(Collection<ParsedAttachment> attachments, MessageId ownerMessageId) {
        return Flux.fromIterable(attachments).concatMap(attachment -> this.storeAttachmentAsync((ParsedAttachment)attachment, ownerMessageId)).collectList();
    }

    private Mono<MessageAttachmentMetadata> storeAttachmentAsync(ParsedAttachment parsedAttachment, MessageId ownerMessageId) {
        return Mono.fromCallable(() -> ((ParsedAttachment)parsedAttachment).getContent()).flatMap(content -> Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), parsedAttachment.getContent(), BlobStore.StoragePolicy.LOW_COST)).flatMap(blobId -> {
            AttachmentId attachmentId = this.attachmentIdAssignationStrategy.assign(parsedAttachment, ownerMessageId);
            return this.postgresAttachmentDAO.storeAttachment(AttachmentMetadata.builder().attachmentId(attachmentId).type(parsedAttachment.getContentType()).size(((Long)Throwing.supplier(() -> ((ByteSource)content).size()).get()).longValue()).messageId(ownerMessageId).build(), (BlobId)blobId).thenReturn((Object)((MessageAttachmentMetadata)Throwing.supplier(() -> parsedAttachment.asMessageAttachment(attachmentId, ownerMessageId)).get()));
        }));
    }
}

