/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.pushsubscription;

import eu.timepit.refined.api.Refined;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.pushsubscription.DefaultWebPushClient$;
import org.apache.james.jmap.pushsubscription.PushClientConfiguration;
import org.apache.james.jmap.pushsubscription.PushRequest;
import org.apache.james.jmap.pushsubscription.PushUrgency;
import org.apache.james.jmap.pushsubscription.PushUrgency$;
import org.apache.james.jmap.pushsubscription.WebPushClient;
import org.apache.james.jmap.pushsubscription.WebPushClientHeader$;
import org.apache.james.jmap.pushsubscription.WebPushInvalidRequestException;
import org.apache.james.jmap.pushsubscription.WebPushTemporarilyUnavailableException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dt!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0005\u0004%\t!\u000b\u0005\u0007[\u0005\u0001\u000b\u0011\u0002\u0016\t\u000b9\nA\u0011B\u0018\u0007\ty\t\u0002!\u0011\u0005\t{\u0019\u0011\t\u0011)A\u0005}!)aE\u0002C\u0001\u000b\"9\u0011K\u0002b\u0001\n\u0003\u0011\u0006BB*\u0007A\u0003%\u0001\u0007C\u0003U\r\u0011\u0005S\u000bC\u0003o\r\u0011%q\u000eC\u0003o\r\u0011%!\u0010C\u0004\u0002\u001a\u0019!I!a\u0007\t\u000f\u0005%c\u0001\"\u0003\u0002L\u0005!B)\u001a4bk2$x+\u001a2QkND7\t\\5f]RT!AE\n\u0002!A,8\u000f[:vEN\u001c'/\u001b9uS>t'B\u0001\u000b\u0016\u0003\u0011QW.\u00199\u000b\u0005Y9\u0012!\u00026b[\u0016\u001c(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001e\u00035\t\u0011C\u0001\u000bEK\u001a\fW\u000f\u001c;XK\n\u0004Vo\u001d5DY&,g\u000e^\n\u0003\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001d\u0003\u0015\u0002Vk\u0015%`'\u0016\u0013f+\u0012*`\u000bJ\u0013vJU0S\u000bN\u0003vJT*F?6\u000b\u0005l\u0018'F\u001d\u001e#\u0006*F\u0001+!\t\t3&\u0003\u0002-E\t\u0019\u0011J\u001c;\u0002MA+6\u000bS0T\u000bJ3VIU0F%J{%k\u0018*F'B{ejU#`\u001b\u0006Cv\fT#O\u000fRC\u0005%A\bck&dG\r\u0013;ua\u000ec\u0017.\u001a8u)\t\u0001D\b\u0005\u00022u5\t!G\u0003\u00024i\u000511\r\\5f]RT!!\u000e\u001c\u0002\t!$H\u000f\u001d\u0006\u0003oa\nQA\\3uifT\u0011!O\u0001\be\u0016\f7\r^8s\u0013\tY$G\u0001\u0006IiR\u00048\t\\5f]RDQ!P\u0003A\u0002y\nQbY8oM&<WO]1uS>t\u0007CA\u000f@\u0013\t\u0001\u0015CA\fQkND7\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]N\u0019a\u0001\t\"\u0011\u0005u\u0019\u0015B\u0001#\u0012\u000559VM\u0019)vg\"\u001cE.[3oiR\u0011ai\u0012\t\u0003;\u0019AQ!\u0010\u0005A\u0002yB#\u0001C%\u0011\u0005){U\"A&\u000b\u00051k\u0015AB5oU\u0016\u001cGOC\u0001O\u0003\u001dQ\u0017m[1si\u0006L!\u0001U&\u0003\r%s'.Z2u\u0003)AG\u000f\u001e9DY&,g\u000e^\u000b\u0002a\u0005Y\u0001\u000e\u001e;q\u00072LWM\u001c;!\u0003\u0011\u0001Xo\u001d5\u0015\u0007Y{\u0016\u000eE\u0002X5rk\u0011\u0001\u0017\u0006\u00033f\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u00037b\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005\u0005j\u0016B\u00010#\u0005\u0011)f.\u001b;\t\u000b\u0001\\\u0001\u0019A1\u0002\u001bA,8\u000f[*feZ,'/\u0016:m!\t\u0011w-D\u0001d\u0015\t!W-A\u0003n_\u0012,GN\u0003\u0002g'\u0005\u0019\u0011\r]5\n\u0005!\u001c'!\u0007)vg\"\u001cVOY:de&\u0004H/[8o'\u0016\u0014h/\u001a:V%2CQA[\u0006A\u0002-\fqA]3rk\u0016\u001cH\u000f\u0005\u0002\u001eY&\u0011Q.\u0005\u0002\f!V\u001c\bNU3rk\u0016\u001cH/\u0001\u0005wC2LG-\u0019;f)\t\u0001\u0018\u0010E\u0002ro\u0006l\u0011A\u001d\u0006\u0003gR\f\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005\r*(B\u0001<9\u0003\u0011\u0019wN]3\n\u0005a\u0014(!B*N_:|\u0007\"\u00021\r\u0001\u0004\tG#B>\u0002\u0014\u0005U\u0001\u0003\u0002?\u0000\u0003\u0007i\u0011! \u0006\u0003}\n\nA!\u001e;jY&\u0019\u0011\u0011A?\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u00079,GO\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\u0011\t\t\"a\u0002\u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\u0006A6\u0001\r!\u0019\u0005\b\u0003/i\u0001\u0019AA\u0002\u0003-Ig.\u001a;BI\u0012\u0014Xm]:\u00021\u00054G/\u001a:I)R\u0003&+Z:q_:\u001cX\rS1oI2,'\u000f\u0006\u0004\u0002\u001e\u0005M\u0012Q\b\t\u0007\u0003?\t\u0019#a\n\u000e\u0005\u0005\u0005\"BA:v\u0013\u0011\t)#!\t\u0003\t5{gn\u001c\t\u0005\u0003S\ty#\u0004\u0002\u0002,)!\u0011QFA\u0006\u0003\u0011a\u0017M\\4\n\t\u0005E\u00121\u0006\u0002\u0005->LG\rC\u0004\u000269\u0001\r!a\u000e\u0002\u0019!$H\u000f\u001d*fgB|gn]3\u0011\u0007E\nI$C\u0002\u0002<I\u0012!\u0003\u0013;ua\u000ec\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\"9\u0011q\b\bA\u0002\u0005\u0005\u0013a\u00023bi\u0006\u0014UO\u001a\t\u0005\u0003\u0007\n)%D\u00017\u0013\r\t9E\u000e\u0002\f\u0005f$XMQ;g\u001b>tw.A\tqe\u0016\u0004&o\\2fgNLgn\u001a#bi\u0006$B!!\u0014\u0002fA1\u0011qDA\u0012\u0003\u001f\u0002B!!\u0015\u0002`9!\u00111KA.!\r\t)FI\u0007\u0003\u0003/R1!!\u0017\u001c\u0003\u0019a$o\\8u}%\u0019\u0011Q\f\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\rM#(/\u001b8h\u0015\r\tiF\t\u0005\b\u0003\u007fy\u0001\u0019AA!\u0001")
public class DefaultWebPushClient
implements WebPushClient {
    private final PushClientConfiguration configuration;
    private final HttpClient httpClient;

    public static int PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH() {
        return DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH();
    }

    public HttpClient httpClient() {
        return this.httpClient;
    }

    @Override
    public Publisher<BoxedUnit> push(PushSubscriptionServerURL pushServerUrl, PushRequest request) {
        return this.validate(pushServerUrl).flatMap((Function1 & Serializable)url -> {
            Mono mono = ((HttpClient.RequestSender)this.httpClient().headers(builder -> {
                builder.add(WebPushClientHeader$.MODULE$.TIME_TO_LIVE(), (Object)request.ttl());
                builder.add(WebPushClientHeader$.MODULE$.MESSAGE_URGENCY(), (Object)((PushUrgency)request.urgency().getOrElse((Function0 & Serializable)() -> PushUrgency$.MODULE$.default())).value());
                request.topic().foreach((Function1 & Serializable)t -> builder.add(WebPushClientHeader$.MODULE$.TOPIC(), (Object)((String)((Refined)t).value())));
                request.contentCoding().foreach((Function1 & Serializable)f -> builder.add(WebPushClientHeader$.MODULE$.CONTENT_ENCODING(), (Object)f.value()));
            }).post().uri(url.value().toString())).send((Publisher)SMono$.MODULE$.just((Object)Unpooled.wrappedBuffer((byte[])request.payload()))).responseSingle((httpResponse, dataBuf) -> this.afterHTTPResponseHandler((HttpClientResponse)httpResponse, (ByteBufMono)dataBuf));
            SMono$.MODULE$.empty();
            return SMono$.MODULE$.apply((Publisher)mono.thenReturn((Object)BoxedUnit.UNIT));
        });
    }

    private SMono<PushSubscriptionServerURL> validate(PushSubscriptionServerURL pushServerUrl) {
        if (this.configuration.preventServerSideRequestForgery()) {
            return SMono$.MODULE$.just((Object)pushServerUrl.value().getHost()).flatMap((Function1 & Serializable)host -> SMono$.MODULE$.fromCallable(() -> InetAddress.getByName(host)).subscribeOn(Schedulers.boundedElastic())).handle((Function2 & Serializable)(inetAddress, sink) -> {
                DefaultWebPushClient.$anonfun$validate$3(this, pushServerUrl, inetAddress, sink);
                return BoxedUnit.UNIT;
            }).then(SMono$.MODULE$.just((Object)pushServerUrl));
        }
        return SMono$.MODULE$.just((Object)pushServerUrl);
    }

    private Try<InetAddress> validate(PushSubscriptionServerURL pushServerUrl, InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2.isSiteLocalAddress()) {
            return new Failure((Throwable)new IllegalArgumentException("JMAP Push subscription " + pushServerUrl + " is targeting a site local address " + inetAddress + ". This could be an attempt for server-side request forgery."));
        }
        if (inetAddress2.isLoopbackAddress()) {
            return new Failure((Throwable)new IllegalArgumentException("JMAP Push subscription " + pushServerUrl + " is targeting a loopback address " + inetAddress + ". This could be an attempt for server-side request forgery."));
        }
        if (inetAddress2.isLinkLocalAddress()) {
            return new Failure((Throwable)new IllegalArgumentException("JMAP Push subscription " + pushServerUrl + " is targeting a link local address " + inetAddress + ". This could be an attempt for server-side request forgery."));
        }
        return new Success((Object)inetAddress);
    }

    private Mono<Void> afterHTTPResponseHandler(HttpClientResponse httpResponse, ByteBufMono dataBuf) {
        return Mono.just((Object)httpResponse.status()).flatMap(x0$1 -> {
            boolean bl;
            HttpResponseStatus httpResponseStatus = x0$1;
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
            if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
                bl = true;
            } else {
                HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.CREATED;
                HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
                if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                    bl = true;
                } else {
                    HttpResponseStatus httpResponseStatus6 = HttpResponseStatus.ACCEPTED;
                    HttpResponseStatus httpResponseStatus7 = httpResponseStatus;
                    bl = !(httpResponseStatus6 != null ? !httpResponseStatus6.equals(httpResponseStatus7) : httpResponseStatus7 != null);
                }
            }
            if (bl) {
                return Mono.empty();
            }
            HttpResponseStatus httpResponseStatus8 = HttpResponseStatus.BAD_REQUEST;
            HttpResponseStatus httpResponseStatus9 = httpResponseStatus;
            if (!(httpResponseStatus8 != null ? !httpResponseStatus8.equals(httpResponseStatus9) : httpResponseStatus9 != null)) {
                return this.preProcessingData(dataBuf).flatMap(string2 -> Mono.error((Throwable)new WebPushInvalidRequestException((String)string2)));
            }
            if (httpResponseStatus != null) {
                HttpResponseStatus httpResponseStatus10 = httpResponseStatus;
                return this.preProcessingData(dataBuf).flatMap(string2 -> Mono.error((Throwable)new WebPushTemporarilyUnavailableException(httpResponseStatus10.code(), (String)string2)));
            }
            throw new MatchError((Object)httpResponseStatus);
        }).then();
    }

    private Mono<String> preProcessingData(ByteBufMono dataBuf) {
        return dataBuf.asString(StandardCharsets.UTF_8).switchIfEmpty(Mono.just((Object)"")).map(content -> {
            if (content.length() > DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH()) {
                return content.substring(DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH());
            }
            return content;
        });
    }

    public static final /* synthetic */ void $anonfun$validate$3(DefaultWebPushClient $this, PushSubscriptionServerURL pushServerUrl$1, InetAddress inetAddress, SynchronousSink sink) {
        $this.validate(pushServerUrl$1, inetAddress).fold((Function1 & Serializable)x$1 -> {
            sink.error(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$1 -> {
            sink.next((Object)x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public DefaultWebPushClient(PushClientConfiguration configuration) {
        this.configuration = configuration;
        this.httpClient = DefaultWebPushClient$.MODULE$.org$apache$james$jmap$pushsubscription$DefaultWebPushClient$$buildHttpClient(configuration);
    }
}

