/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderView;
import org.apache.james.jmap.mail.EmailHeaders$;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailViewFactory;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001B\u0003\u0005!!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053G\u0001\fF[\u0006LG\u000eS3bI\u0016\u0014h+[3x\r\u0006\u001cGo\u001c:z\u0015\t1q!\u0001\u0003nC&d'B\u0001\u0005\n\u0003\u0011QW.\u00199\u000b\u0005)Y\u0011!\u00026b[\u0016\u001c(B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#]\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007c\u0001\r\u001a75\tQ!\u0003\u0002\u001b\u000b\t\u0001R)\\1jYZKWm\u001e$bGR|'/\u001f\t\u00031qI!!H\u0003\u0003\u001f\u0015k\u0017-\u001b7IK\u0006$WM\u001d,jK^\faB_8oK&#\u0007K]8wS\u0012,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\u000f\u00051Q.\u001a;i_\u0012L!\u0001J\u0011\u0003\u001di{g.Z%e!J|g/\u001b3fe\u00061A(\u001b8jiz\"\"a\n\u0015\u0011\u0005a\u0001\u0001\"\u0002\u0010\u0003\u0001\u0004y\u0002F\u0001\u0002+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0004j]*,7\r\u001e\u0006\u0002_\u00059!.Y6beR\f\u0017BA\u0019-\u0005\u0019IeN[3di\u00069Ao\\#nC&dGc\u0001\u001bXAR\u0011Qg\u000f\t\u0004meZR\"A\u001c\u000b\u0005a\u001a\u0012\u0001B;uS2L!AO\u001c\u0003\u0007Q\u0013\u0018\u0010C\u0003=\u0007\u0001\u0007Q(A\u0004nKN\u001c\u0018mZ3\u0011\tIq\u0004\tS\u0005\u0003\u007fM\u0011a\u0001V;qY\u0016\u0014\u0004CA!G\u001b\u0005\u0011%BA\"E\u0003\u0015iw\u000eZ3m\u0015\t)\u0015\"A\u0004nC&d'm\u001c=\n\u0005\u001d\u0013%!C'fgN\fw-Z%e!\rI\u0015\u000b\u0016\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!T\b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012B\u0001)\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0007M+\u0017O\u0003\u0002Q'A\u0011\u0011)V\u0005\u0003-\n\u0013Q\"T3tg\u0006<WMU3tk2$\b\"\u0002-\u0004\u0001\u0004I\u0016!\u00055u[2$V\r\u001f;FqR\u0014\u0018m\u0019;peB\u0011!LX\u0007\u00027*\u0011A,X\u0001\u0005QRlGN\u0003\u00029\u0013%\u0011ql\u0017\u0002\u0012\u0011RlG\u000eV3yi\u0016CHO]1di>\u0014\b\"B1\u0004\u0001\u0004\u0011\u0017a\u0002:fcV,7\u000f\u001e\t\u00031\rL!\u0001Z\u0003\u0003\u001f\u0015k\u0017-\u001b7HKR\u0014V-];fgR\u0004")
public class EmailHeaderViewFactory
implements EmailViewFactory<EmailHeaderView> {
    private final ZoneIdProvider zoneIdProvider;

    @Override
    public Try<EmailHeaderView> toEmail(HtmlTextExtractor htmlTextExtractor, EmailGetRequest request, Tuple2<MessageId, Seq<MessageResult>> message) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$19 -> x$19.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$20 -> new Success(x$20)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> Email$.MODULE$.parseAsMime4JMessage((MessageResult)firstMessage).flatMap((Function1 & Serializable)mime4JMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> Email$.MODULE$.mergeKeywords((Seq<MessageResult>)((Seq)message._2())).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            MailboxIds x$4 = mailboxIds;
            UTCDate x$5 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$6 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            Keywords x$7 = keywords;
            return new EmailHeaderView(new EmailMetadata(x$1, x$2, x$3, x$7, x$4, x$6, x$5), EmailHeaders$.MODULE$.from($this.zoneIdProvider.get(), (Message)mime4JMessage), EmailHeaders$.MODULE$.extractSpecificHeaders(request.properties(), $this.zoneIdProvider.get(), mime4JMessage.getHeader()));
        }))));
    }

    @Inject
    public EmailHeaderViewFactory(ZoneIdProvider zoneIdProvider) {
        this.zoneIdProvider = zoneIdProvider;
    }
}

