/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UuidBuilder {
    private Integer version;
    private ByteBuffer buffer = ByteBuffer.allocate(16);

    public UuidBuilder() {
        this.version = null;
    }

    public UuidBuilder(int version) {
        if ((long)version < 0L || (long)version > 15L) {
            throw new IllegalArgumentException("Invalid version number");
        }
        this.version = version;
    }

    public synchronized UuidBuilder put(long value) {
        this.buffer.putLong(value);
        return this;
    }

    public synchronized UuidBuilder put(int value) {
        this.buffer.putInt(value);
        return this;
    }

    public synchronized UuidBuilder put(short value) {
        this.buffer.putShort(value);
        return this;
    }

    public synchronized UuidBuilder put(byte value) {
        this.buffer.put(value);
        return this;
    }

    public synchronized UuidBuilder put(byte[] array) {
        this.buffer.put(array);
        return this;
    }

    public synchronized UUID build() {
        this.validate();
        this.buffer.rewind();
        if (this.version != null) {
            long msb = this.buffer.getLong() & 0xFFFFFFFFFFFF0FFFL | ((long)this.version.intValue() & 0xFL) << 12;
            long lsb = this.buffer.getLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
            return new UUID(msb, lsb);
        }
        long msb = this.buffer.getLong();
        long lsb = this.buffer.getLong();
        return new UUID(msb, lsb);
    }

    private synchronized void validate() {
        if (this.buffer.hasRemaining()) {
            throw new BufferUnderflowException();
        }
    }
}

